/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.flowmanager.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.IndexColumn;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowRef;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStepErrorRef;
import org.ow2.petals.flowwatch.flowmanager.bo.StepParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="FLOWSTEPREF", uniqueConstraints={@UniqueConstraint(columnNames={"flowref_id", "name"}), @UniqueConstraint(columnNames={"flowref_id", "interfaceName", "serviceName"})})
@NamedQueries(value={@NamedQuery(name="FlowStepRef.getById", query="select o from FlowStepRef o where o.id = :id"), @NamedQuery(name="FlowStepRef.getByType", query="select o from FlowStepRef o where o.flowref.type = :type"), @NamedQuery(name="FlowStepRef.getStartStepByFlowType", query="select o from FlowStepRef o where o.flowref.type = :type and o.flowStartStep = :start"), @NamedQuery(name="FlowStepRef.getEndStepByFlowType", query="select o from FlowStepRef o where o.flowref.type = :type and o.flowEndStep = :end"), @NamedQuery(name="FlowStepRef.getByTypeIntNameServName", query="select o from FlowStepRef o where o.flowref.type = :type and o.interfaceName = :interfaceName and o.serviceName = :serviceName")})
public class FlowStepRef
implements Serializable {
    private static final long serialVersionUID = -4099365746136084661L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column
    private String interfaceName;
    @Column
    private String serviceName;
    @Column
    private String name;
    @Column
    private boolean flowStartStep;
    @Column
    private boolean flowEndStep;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="flowref_id", nullable=false, updatable=false)
    @ForeignKey(name="FK_FLOWREF_id_FLOWSTEPREF_flowref")
    private FlowRef flowref;
    @OneToMany(mappedBy="flowstepref", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @MapKey(name="errorCode")
    private Map<Integer, FlowStepErrorRef> errorMessages;
    @Column
    private String successMessage;
    @Column
    private String defaultErrorMessage;
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="FLOWREF_PARAMNAMES")
    @IndexColumn(name="idx")
    @ForeignKey(name="FK_PARAMNAMES_id_FLOWREF")
    private List<StepParameter> parameterNames = new ArrayList<StepParameter>();

    public long getId() {
        return this.id;
    }

    public boolean isFlowStartStep() {
        return this.flowStartStep;
    }

    public void setFlowStartStep(boolean flowStartStep) {
        this.flowStartStep = flowStartStep;
    }

    public boolean isFlowEndStep() {
        return this.flowEndStep;
    }

    public void setFlowEndStep(boolean flowEndStep) {
        this.flowEndStep = flowEndStep;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowRef getFlowref() {
        return this.flowref;
    }

    public void setFlowref(FlowRef flowref) {
        this.flowref = flowref;
    }

    public Map<Integer, FlowStepErrorRef> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(Map<Integer, FlowStepErrorRef> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public List<StepParameter> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(List<StepParameter> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public void addParameterName(StepParameter parameterName) {
        this.parameterNames.add(parameterName);
    }

    public void addParameterName(int index, StepParameter parameterName) {
        this.parameterNames.add(index, parameterName);
    }

    public void updateParameterName(int index, StepParameter parameterName) {
        this.parameterNames.set(index, parameterName);
    }

    public void removeParameterName(int index) {
        this.parameterNames.remove(index);
    }
}

