/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.flowmanager.dao;

import com.trg.search.ISearch;
import com.trg.search.Search;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.transform.Transformers;
import org.ow2.petals.flowwatch.flowmanager.CreateSqLQueryFlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.CreateSqlQueryFlow;
import org.ow2.petals.flowwatch.flowmanager.FlowWithParams;
import org.ow2.petals.flowwatch.flowmanager.GlobalFlowParam;
import org.ow2.petals.flowwatch.flowmanager.RequestOptions;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.flowmanager.dao.AbstractFlowDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowDAO
extends AbstractFlowDAO<Flow, String> {
    public Flow loadByPetalsId(String petalsId) {
        Search search = new Search();
        Flow flow = (Flow)this.searchUnique((ISearch)search.addFilterEqual("idpetals", (Object)petalsId));
        return flow;
    }

    public List<Flow> loadAllStarted() {
        return this.search((ISearch)new Search().addFilterNotNull("startDate").addSortDesc("startDate"));
    }

    public List<Flow> loadByType(int type) {
        return this.search((ISearch)new Search().addFilterEqual("type", (Object)type));
    }

    public List<Flow> loadAllStartedByType(int type) {
        return this.search((ISearch)new Search().addFilterEqual("type", (Object)type).addFilterNotNull("startDate").addSortDesc("startDate"));
    }

    public List<Flow> loadAllStartedByTypeWithDateFilter(int type, Date after, Date before) {
        Search search = new Search();
        search.addFilterNotNull("startDate");
        search.addFilterEqual("type", (Object)type);
        search.addSortDesc("startDate");
        if (after != null) {
            search.addFilterGreaterOrEqual("startDate", (Object)after);
        }
        if (before != null) {
            search.addFilterLessOrEqual("startDate", (Object)before);
        }
        return this.search((ISearch)search);
    }

    public int countAllFlows(Date after, Date before, RequestOptions requestOptions) {
        CreateSqlQueryFlow queryFlow = new CreateSqlQueryFlow();
        String query = queryFlow.createCountQuery(after, before, requestOptions);
        int count = this.getCount(query);
        return count;
    }

    public int countAllFlowsByType(Date after, Date before, List<GlobalFlowParam> globalParams, short flowType, RequestOptions requestOptions) {
        CreateSqLQueryFlowWithParams queryFlowWithParams = new CreateSqLQueryFlowWithParams();
        String query = queryFlowWithParams.createCountQuery(after, before, globalParams, flowType, requestOptions);
        int count = this.getCount(query);
        return count;
    }

    public List<Flow> getAllFlows(Date after, Date before, RequestOptions requestOptions) {
        CreateSqlQueryFlow queryFlow = new CreateSqlQueryFlow();
        String query = queryFlow.createGetQuery(after, before, requestOptions);
        Session session = this.getSession();
        Transaction tx = session.beginTransaction();
        ArrayList<Flow> result = new ArrayList();
        Query q = session.createSQLQuery(query).setResultTransformer(Transformers.aliasToBean(Flow.class));
        if (q != null && (result = q.list()) != null) {
            for (Flow flow : result) {
                if (flow.getEndDate() != null) continue;
                flow.setStatus(-1);
            }
        }
        tx.commit();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowWithParams> getAllFlowsByType(Date after, Date before, List<GlobalFlowParam> globalParams, short flowType, RequestOptions requestOptions) {
        CreateSqLQueryFlowWithParams queryFlowWithParams = new CreateSqLQueryFlowWithParams();
        String query = queryFlowWithParams.createGetQuery(after, before, globalParams, flowType, requestOptions);
        Statement stt = null;
        StatelessSession sess = null;
        Connection con = null;
        ArrayList<FlowWithParams> ret = new ArrayList<FlowWithParams>();
        ArrayList<String> listElements = null;
        sess = this.getSessionFactory().openStatelessSession();
        try {
            con = sess.connection();
            stt = con.createStatement();
            Transaction tx = sess.beginTransaction();
            ResultSet rs = stt.executeQuery(query);
            while (rs.next()) {
                FlowWithParams flowWithParams = new FlowWithParams();
                flowWithParams.setId(rs.getLong(1));
                flowWithParams.setIdpetals(rs.getString(2));
                flowWithParams.setStartDate(rs.getTimestamp(3));
                flowWithParams.setEndDate(rs.getTimestamp(4));
                flowWithParams.setStatus(rs.getInt(5));
                listElements = new ArrayList<String>();
                for (int i = 0; i < globalParams.size(); ++i) {
                    String element = rs.getString(i + 6);
                    listElements.add(element);
                }
                flowWithParams.setElement(listElements);
                ret.add(flowWithParams);
            }
            tx.commit();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (stt != null) {
                try {
                    stt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (sess != null) {
                sess.close();
            }
        }
        if (ret != null) {
            for (FlowWithParams flow : ret) {
                if (flow.getEndDate() != null) continue;
                flow.setStatus(-1);
            }
        }
        return ret;
    }

    private int getCount(String query) {
        Session session = this.getSession();
        Transaction tx = session.beginTransaction();
        int count = 0;
        Object countTmp = session.createSQLQuery(query).uniqueResult();
        if (countTmp instanceof BigInteger) {
            count = new Integer(((BigInteger)countTmp).intValue());
        }
        if (countTmp instanceof Long) {
            long result = (Long)countTmp;
            count = (int)result;
        }
        if (countTmp instanceof BigDecimal) {
            count = new Integer(((BigDecimal)countTmp).intValue());
        }
        tx.commit();
        return count;
    }
}

