/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.flowwatch.notification;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.ow2.petals.flowwatch.flowmanager.ConfigAndFactoryManager;
import org.ow2.petals.flowwatch.flowmanager.bo.Flow;
import org.ow2.petals.flowwatch.flowmanager.bo.FlowStep;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowDAO;
import org.ow2.petals.flowwatch.flowmanager.dao.FlowStepDAO;
import org.ow2.petals.flowwatch.notification.Notification;
import org.ow2.petals.flowwatch.utils.HibernateUtils;
import org.ow2.petals.flowwatch.utils.NotificationProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationProcessor
extends ConfigAndFactoryManager {
    private FlowDAO flowDAO = new FlowDAO();
    private FlowStepDAO flowStepDAO = new FlowStepDAO();
    private Map<String, Flow> flowMap = new ConcurrentHashMap<String, Flow>();
    private Map<String, FlowStep> flowStepMap = new ConcurrentHashMap<String, FlowStep>();

    public void process(List<Notification> notificationList) throws NotificationProcessingException {
        if (notificationList != null) {
            Transaction tx = null;
            try {
                Session session = HibernateUtils.getConfigAndFactory().getFactory().getCurrentSession();
                tx = session.beginTransaction();
                for (Notification notification : notificationList) {
                    if (notification == null || !notification.isValid()) continue;
                    Flow flow = this.createOrRetrieveFlow(notification);
                    this.createOrRetrieveFlowStep(notification, flow);
                }
                this.save();
                tx.commit();
            }
            catch (Throwable t) {
                tx.rollback();
                throw new NotificationProcessingException(t);
            }
        } else {
            throw new NotificationProcessingException("Can't process a null notification list");
        }
    }

    private void createOrRetrieveFlowStep(Notification notification, Flow flow) throws NotificationProcessingException {
        FlowStep flowStep = this.retrieveFlowStep(notification);
        if (flowStep == null) {
            this.createFlowStep(notification, flow);
        }
        this.updateFlowStep(notification);
    }

    private Flow createOrRetrieveFlow(Notification notification) throws Throwable {
        Flow flow = null;
        flow = this.retrieveFlow(notification);
        if (flow == null) {
            flow = this.createFlow(notification);
        }
        return flow;
    }

    private void save() {
        Collection<Flow> flowCollection = this.flowMap.values();
        Object[] flowArray = flowCollection.toArray(new Flow[flowCollection.size()]);
        this.flowDAO.save(flowArray);
        Collection<FlowStep> flowStepCollection = this.flowStepMap.values();
        Object[] flowStepArray = flowStepCollection.toArray(new FlowStep[flowStepCollection.size()]);
        this.flowStepDAO.save(flowStepArray);
        this.flowMap.clear();
        this.flowStepMap.clear();
    }

    private FlowStep retrieveFlowStep(Notification notification) {
        FlowStep flowStep = null;
        flowStep = this.flowStepMap.get(notification.getMeUUID());
        if (flowStep == null && (flowStep = this.flowStepDAO.loadByMeUUID(notification.getMeUUID())) != null) {
            this.flowStepMap.put(flowStep.getMeUUID(), flowStep);
        }
        return flowStep;
    }

    private Flow retrieveFlow(Notification notification) {
        Flow flow = null;
        flow = this.flowMap.get(notification.getProcessId());
        if (flow == null && (flow = this.flowDAO.loadByPetalsId(notification.getProcessId())) != null) {
            this.flowMap.put(flow.getIdpetals(), flow);
        }
        return flow;
    }

    private Flow createFlow(Notification notification) {
        Flow flow = new Flow();
        flow.setIdpetals(notification.getProcessId());
        flow.setType(notification.getProcessType());
        this.flowMap.put(flow.getIdpetals(), flow);
        return flow;
    }

    private FlowStep createFlowStep(Notification notification, Flow flow) throws NotificationProcessingException {
        FlowStep flowStep = new FlowStep();
        flowStep.setEndpointName(notification.getEndpointName());
        flowStep.setInterfaceName(notification.getInterfaceName());
        flowStep.setServiceName(notification.getServiceName());
        flowStep.setMeUUID(notification.getMeUUID());
        flowStep.setStatus(-1);
        flowStep.setFlow(flow);
        this.flowStepMap.put(flowStep.getMeUUID(), flowStep);
        return flowStep;
    }

    private FlowStep updateFlowStep(Notification notification) throws NotificationProcessingException {
        FlowStep flowStep = this.flowStepMap.get(notification.getMeUUID());
        if (flowStep != null) {
            switch (notification.getStatus()) {
                case -1: {
                    flowStep.setStartDate(notification.getNotifDate());
                    CopyOnWriteArrayList<String> paramList = new CopyOnWriteArrayList<String>();
                    if (notification.getParams() != null && !notification.getParams().isEmpty()) {
                        paramList.addAll(notification.getParams());
                    }
                    if (flowStep.getParameters() != null && !flowStep.getParameters().isEmpty()) {
                        paramList.addAll(flowStep.getParameters());
                    }
                    flowStep.setParameters(paramList);
                    break;
                }
                default: {
                    if (notification.getStatus() < -1) {
                        throw new NotificationProcessingException("Try to process an unsupported notif status: " + notification.getStatus());
                    }
                    flowStep.setStatus(notification.getStatus());
                    flowStep.setEndDate(notification.getNotifDate());
                }
            }
            this.flowStepMap.put(flowStep.getMeUUID(), flowStep);
        }
        return flowStep;
    }
}

