/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.api.artifact;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactException;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.ServiceUnit;
import org.ow2.petals.admin.api.artifact.SharedLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class ArtifactUtils {
    public static final String FACTORY_PROPERTY_KEY = "org.ow2.petals.admin.api.artifact.factory";
    private static final String JBI_XML_PATH = "META-INF/jbi.xml";
    private static final String XPATH_JBI_BC_TYPE = "/*[local-name()='jbi']/*[local-name()='component'][@type='binding-component']";
    private static final String XPATH_JBI_SL_TYPE = "/*[local-name()='jbi']/*[local-name()='shared-library']";
    private static final String XPATH_JBI_SA_TYPE = "/*[local-name()='jbi']/*[local-name()='service-assembly']";
    private static final String XPATH_JBI_SE_TYPE = "/*[local-name()='jbi']/*[local-name()='component'][@type='service-engine']";
    private static final String XPATH_JBI_SU_NAME_AND_TARGETCOMPONENT_LIST = "//*[local-name()='service-unit']/*[local-name()='identification']/*[local-name()='name'] | //*[local-name()='service-unit']/*[local-name()='target']/*[local-name()='component-name']";
    private static final String XPATH_JBI_NAME = "//*[local-name()='identification']/*[local-name()='name']";

    public static final Artifact createArtifact(URL artifactUrl) throws ArtifactException {
        assert (artifactUrl != null);
        return ArtifactUtils.createArtifact(artifactUrl, new Properties());
    }

    public static final Artifact createArtifact(URL artifactUrl, URL configurationFile) throws ArtifactException {
        assert (artifactUrl != null);
        assert (configurationFile != null);
        try {
            Properties configurationProperties = new Properties();
            File tmpConfigurationFile = ArtifactUtils.copyURLToTempZipFile(configurationFile);
            configurationProperties.load(new FileReader(tmpConfigurationFile));
            return ArtifactUtils.createArtifact(artifactUrl, configurationProperties);
        }
        catch (Exception e) {
            throw new ArtifactException(e);
        }
    }

    public static final Artifact createArtifact(URL artifactUrl, Properties configurationProperties) throws ArtifactException {
        assert (artifactUrl != null);
        assert (configurationProperties != null);
        try {
            File tmpJbiFile = ArtifactUtils.copyURLToTempZipFile(artifactUrl);
            Node jbiConfig = ArtifactUtils.extractJbiXml(tmpJbiFile);
            tmpJbiFile.delete();
            XPath xpath = XPathFactory.newInstance().newXPath();
            if (((Boolean)xpath.evaluate(XPATH_JBI_BC_TYPE, jbiConfig, XPathConstants.BOOLEAN)).booleanValue()) {
                return new Component(ArtifactUtils.getName(jbiConfig), Component.ComponentType.BC, configurationProperties);
            }
            if (((Boolean)xpath.evaluate(XPATH_JBI_SE_TYPE, jbiConfig, XPathConstants.BOOLEAN)).booleanValue()) {
                return new Component(ArtifactUtils.getName(jbiConfig), Component.ComponentType.BC, configurationProperties);
            }
            if (((Boolean)xpath.evaluate(XPATH_JBI_SL_TYPE, jbiConfig, XPathConstants.BOOLEAN)).booleanValue()) {
                return new SharedLibrary(ArtifactUtils.getName(jbiConfig));
            }
            if (((Boolean)xpath.evaluate(XPATH_JBI_SA_TYPE, jbiConfig, XPathConstants.BOOLEAN)).booleanValue()) {
                NodeList lst = (NodeList)xpath.evaluate(XPATH_JBI_SU_NAME_AND_TARGETCOMPONENT_LIST, jbiConfig, XPathConstants.NODESET);
                ArrayList<ServiceUnit> sus = new ArrayList<ServiceUnit>();
                for (int i = 0; i < lst.getLength(); i += 2) {
                    Node suName = lst.item(i);
                    Node targetComponentName = lst.item(i + 1);
                    sus.add(new ServiceUnit(suName.getTextContent(), "NOVERSION", targetComponentName.getTextContent()));
                }
                return new ServiceAssembly(ArtifactUtils.getName(jbiConfig), sus);
            }
            String errorMessage = String.format("%s: not a valid JBI archive", artifactUrl.toString());
            throw new ArtifactException(errorMessage);
        }
        catch (Exception e) {
            throw new ArtifactException(e);
        }
    }

    private static final Node extractJbiXml(File archive) throws ZipException, IOException, ParserConfigurationException, SAXException {
        ZipFile zipfile = new ZipFile(archive);
        ZipEntry jbixml = zipfile.getEntry(JBI_XML_PATH);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(zipfile.getInputStream(jbixml));
        doc.getDocumentElement().normalize();
        return doc;
    }

    private static final File copyURLToTempZipFile(URL url) throws IOException {
        File result = File.createTempFile("jbi", ".zip");
        result.deleteOnExit();
        FileUtils.copyURLToFile((URL)url, (File)result);
        return result;
    }

    private static final String getName(Node jbiConfig) {
        try {
            XPath xp = XPathFactory.newInstance().newXPath();
            String result = (String)xp.evaluate(XPATH_JBI_NAME, jbiConfig, XPathConstants.STRING);
            if (result == null) {
                throw new UncheckedException("The artifact name node is mandatory in the file jbi.xml");
            }
            return result;
        }
        catch (XPathExpressionException xpee) {
            throw new UncheckedException((Throwable)xpee);
        }
    }
}

