/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.api.artifact;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.admin.api.artifact.Artifact;
import org.ow2.petals.admin.api.artifact.ArtifactException;
import org.ow2.petals.admin.api.artifact.ArtifactState;
import org.ow2.petals.admin.api.artifact.ArtifactUtils;
import org.ow2.petals.admin.api.artifact.Component;
import org.ow2.petals.admin.api.artifact.ServiceAssembly;
import org.ow2.petals.admin.api.artifact.SharedLibrary;

public class ArtifactUtilsTest {
    protected static final String BC_JBI = "bc.jbi.xml";
    protected static final String SE_JBI = "se.jbi.xml";
    protected static final String SA_JBI = "sa.jbi.xml";
    protected static final String SL_JBI = "sl.jbi.xml";

    @Test
    public void createArtifactTest() throws ArtifactException, IOException {
        Artifact artifact = ArtifactUtils.createArtifact((URL)ArtifactUtilsTest.createArtifactURL(BC_JBI));
        Assert.assertTrue((boolean)(artifact instanceof Component));
        Assert.assertTrue((boolean)(artifact instanceof ArtifactState));
        artifact = ArtifactUtils.createArtifact((URL)ArtifactUtilsTest.createArtifactURL(SE_JBI));
        Assert.assertTrue((boolean)(artifact instanceof Component));
        Assert.assertTrue((boolean)(artifact instanceof ArtifactState));
        artifact = ArtifactUtils.createArtifact((URL)ArtifactUtilsTest.createArtifactURL(SA_JBI));
        Assert.assertTrue((boolean)(artifact instanceof ServiceAssembly));
        Assert.assertTrue((boolean)(artifact instanceof ArtifactState));
        artifact = ArtifactUtils.createArtifact((URL)ArtifactUtilsTest.createArtifactURL(SL_JBI));
        Assert.assertTrue((boolean)(artifact instanceof SharedLibrary));
    }

    @Test
    public void createComponentWithGivenPropertiesTest() throws ArtifactException, IOException {
        Properties expectedProperties = new Properties();
        expectedProperties.put("key1", "value1");
        expectedProperties.put("key2", "value2");
        Component component = (Component)ArtifactUtils.createArtifact((URL)ArtifactUtilsTest.createArtifactURL(BC_JBI), (Properties)expectedProperties);
        Assert.assertEquals((Object)expectedProperties, (Object)component.getParameters());
        URL propertiesFile = Thread.currentThread().getContextClassLoader().getResource("test.properties");
        component = (Component)ArtifactUtils.createArtifact((URL)ArtifactUtilsTest.createArtifactURL(BC_JBI), (URL)propertiesFile);
        Assert.assertEquals((Object)expectedProperties, (Object)component.getParameters());
    }

    public static URL createArtifactURL(String jbiFile) throws ZipException, IOException {
        byte[] buf = new byte[1024];
        URL jbiURL = Thread.currentThread().getContextClassLoader().getResource(jbiFile);
        File zip = File.createTempFile("jbi", ".zip");
        zip.deleteOnExit();
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
        FileInputStream fis = new FileInputStream(new File(jbiURL.getFile()));
        zos.putNextEntry(new ZipEntry("META-INF/jbi.xml"));
        int len = 0;
        while ((len = fis.read(buf)) > 0) {
            zos.write(buf, 0, len);
        }
        zos.closeEntry();
        fis.close();
        zos.close();
        return zip.toURI().toURL();
    }
}

