/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.util.List;
import org.ow2.petals.admin.api.RegistryAdministration;
import org.ow2.petals.admin.api.exception.RegistryAdministrationException;
import org.ow2.petals.admin.api.exception.RegistryRegexpPatternException;
import org.ow2.petals.admin.jmx.JMXClientConnection;
import org.ow2.petals.admin.jmx.registry.JMXRegistryView;
import org.ow2.petals.admin.registry.RegistryView;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.EndpointRegistryServiceErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;

public class JMXRegistryAdministration
implements RegistryAdministration {
    protected JMXRegistryAdministration() {
    }

    public void synchronizeRegistry() throws RegistryAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            client.getEndpointRegistryClient().synchronizeRegistry();
        }
        catch (ConnectionErrorException cee) {
            throw new RegistryAdministrationException((Throwable)cee);
        }
        catch (PetalsAdminServiceErrorException pasee) {
            throw new RegistryAdministrationException((Throwable)pasee);
        }
        catch (EndpointRegistryServiceDoesNotExistException ersdnee) {
            throw new RegistryAdministrationException((Throwable)ersdnee);
        }
        catch (EndpointRegistryServiceErrorException erssee) {
            throw new RegistryAdministrationException((Throwable)erssee);
        }
    }

    public void synchronizeRegistryOnAllNodes() {
        throw new UncheckedException("Not yet implemented");
    }

    public RegistryView getRegistryContent(String endpointNameRegex, String serviceNameRegex, String interfaceNameRegex) throws RegistryRegexpPatternException, RegistryAdministrationException {
        try {
            JMXClient client = JMXClientConnection.getJMXClient();
            List endpointMaps = client.getEndpointRegistryClient().getAllEndpoints();
            return new JMXRegistryView(endpointMaps, endpointNameRegex, serviceNameRegex, interfaceNameRegex);
        }
        catch (ConnectionErrorException cee) {
            throw new RegistryAdministrationException((Throwable)cee);
        }
        catch (NumberFormatException nfe) {
            throw new RegistryAdministrationException((Throwable)nfe);
        }
        catch (EndpointRegistryServiceErrorException ersee) {
            throw new RegistryAdministrationException((Throwable)ersee);
        }
        catch (EndpointRegistryServiceDoesNotExistException ersdnee) {
            throw new RegistryAdministrationException((Throwable)ersdnee);
        }
    }
}

