/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.admin.jmx.topology;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.petals.admin.topology.Container;
import org.ow2.petals.admin.topology.Domain;
import org.ow2.petals.admin.topology.Subdomain;

public class TopologyUtils {
    private static final Map<String, Container.PortType> portTypes;

    public static final Domain createListOfDomains(Set<Map<String, String>> topology) {
        Domain domain = null;
        ArrayList<Subdomain> subdomains = new ArrayList<Subdomain>();
        HashMap containers = new HashMap();
        for (Map<String, String> map : topology) {
            String name;
            String topologyType = map.get("type");
            if (topologyType.equals("domain")) {
                name = map.get("domainName");
                domain = new Domain(name);
                continue;
            }
            if (topologyType.equals("subdomain")) {
                name = map.get("subdomainName");
                Subdomain subdomain = new Subdomain(name);
                subdomains.add(subdomain);
                continue;
            }
            if (topologyType.equals("container")) {
                List<Container> containersForThisSubDomain;
                String subdomain = map.get("subdomainName");
                if (containers.containsKey(subdomain)) {
                    containersForThisSubDomain = (List)containers.get(subdomain);
                } else {
                    containersForThisSubDomain = new ArrayList();
                    containers.put(subdomain, containersForThisSubDomain);
                }
                String name2 = map.get("containerName");
                Container.NodeType nodeType = Container.NodeType.valueOf((String)map.get("nodeType"));
                String host = map.get("host");
                HashMap<Container.PortType, Integer> ports = new HashMap<Container.PortType, Integer>();
                for (String portType : portTypes.keySet()) {
                    if (!map.containsKey(portType)) continue;
                    int portValue = Integer.valueOf(map.get(portType));
                    ports.put(portTypes.get(portType), portValue);
                }
                Container container = new Container(name2, nodeType, host, ports);
                containersForThisSubDomain.add(container);
                continue;
            }
            String errorMessage = String.format("Unrecognized topology type: '%s'", topologyType);
            throw new UncheckedException(errorMessage);
        }
        if (domain == null) {
            String errorMessage = "Error in the topology map: no domain";
            throw new UncheckedException(errorMessage);
        }
        for (Subdomain subdomain : subdomains) {
            subdomain.addContainers((List)containers.get(subdomain.getName()));
        }
        domain.addSubdomain(subdomains);
        return domain;
    }

    static {
        HashMap<String, Container.PortType> tempPortTypes = new HashMap<String, Container.PortType>();
        tempPortTypes.put("webserviceHTTPPort", Container.PortType.HTTP_WEBSERVICE);
        tempPortTypes.put("jmxRMIPort", Container.PortType.JMX);
        tempPortTypes.put("transportTCPPort", Container.PortType.TCP_TRANSPORT);
        tempPortTypes.put("registryPort", Container.PortType.REGISTRY);
        portTypes = Collections.unmodifiableMap(tempPortTypes);
    }
}

