/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.ant.AbstractInstallerAntTask;

public class AbstractInstallerAntTaskTest {
    @Test
    public void testValidateFileParameter_Null() {
        FileInstallerAntTask fiat = new FileInstallerAntTask(null);
        try {
            fiat.validateFileParameter();
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Missing attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Empty() {
        FileInstallerAntTask fiat = new FileInstallerAntTask("");
        try {
            fiat.validateFileParameter();
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Empty attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Invalid() {
        String invalidFile = "/tmp/foo";
        FileInstallerAntTask fiat = new FileInstallerAntTask("/tmp/foo");
        try {
            fiat.validateFileParameter();
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("/tmp/foo"));
            Assert.assertTrue((boolean)e.getMessage().contains("is not a valid archive (zip or jar required)"));
        }
    }

    @Test
    public void testValidateFileParameter_JAR() throws Exception {
        FileInstallerAntTask fiat = new FileInstallerAntTask("/tmp/foo.jar");
        Assert.assertEquals((Object)new URL("file:/tmp/foo.jar"), (Object)fiat.validateFileParameter());
    }

    @Test
    public void testValidateFileParameter_ZIP() throws Exception {
        FileInstallerAntTask fiat = new FileInstallerAntTask("/tmp/foo.zip");
        Assert.assertEquals((Object)new URL("file:/tmp/foo.zip"), (Object)fiat.validateFileParameter());
    }

    private class FileInstallerAntTask
    extends AbstractInstallerAntTask {
        public FileInstallerAntTask(String file) {
            this.file = file;
        }

        public void doTask() throws Exception {
        }
    }
}

