/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.util.HashMap;
import javax.management.ObjectName;
import org.apache.tools.ant.BuildException;
import org.ow2.petals.ant.AbstractJBIAntTask;

public class ListBindingComponentsTask
extends AbstractJBIAntTask {
    private static final String XMLNS = "http://java.sun.com/xml/ns/jbi/component-info-list";
    private String bindingComponentName;
    private String serviceAssemblyName;
    private String sharedLibraryName;
    private String state;
    private String xmlOutput;

    @Override
    public void doTask() throws Exception {
        if (!(this.state == null || "Shutdown".equalsIgnoreCase(this.state) || "Started".equalsIgnoreCase(this.state) || "Stopped".equalsIgnoreCase(this.state))) {
            throw new BuildException("Invalid state '" + this.state + "' (Valid ones are : '" + "Shutdown" + "', '" + "Started" + "', or '" + "Stopped" + "')");
        }
        ObjectName[] bindings = this.getJMXClient().getAdminServiceClient().getBindingComponents();
        HashMap<ObjectName, String> components = new HashMap<ObjectName, String>();
        for (ObjectName objectName : bindings) {
            boolean found;
            String currentState = this.getJMXClient().getComponentClient(objectName).getState();
            String name = objectName.getKeyProperty("name");
            if (this.bindingComponentName != null) {
                if (!this.bindingComponentName.equals(name)) continue;
                components.put(objectName, currentState);
                break;
            }
            if (this.state != null && !this.state.equalsIgnoreCase(currentState)) continue;
            if (this.serviceAssemblyName != null) {
                String[] serviceAssemblyNames;
                found = false;
                for (String saName : serviceAssemblyNames = this.getJMXClient().getDeploymentServiceClient().getDeployedServiceAssembliesForComponent(name)) {
                    if (!this.serviceAssemblyName.equals(saName)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (this.sharedLibraryName != null) {
                found = false;
                String[] componentNames = this.getJMXClient().getInstallationServiceClient().getInstalledComponentsForSharedlibrary(this.sharedLibraryName);
                for (String componentName : componentNames) {
                    if (!name.equals(componentName)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            components.put(objectName, currentState);
        }
        StringBuffer output = new StringBuffer();
        StringBuffer outputXML = new StringBuffer();
        output.append("#######################################################\n");
        output.append("#                   Binding Components                #\n");
        output.append("#######################################################\n");
        outputXML.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        outputXML.append("<component-info-list xmlns='");
        outputXML.append(XMLNS);
        outputXML.append("' version='1.0'>\n");
        for (ObjectName objectName : components.keySet()) {
            String name = objectName.getKeyProperty("name");
            String description = "";
            String objState = (String)components.get(objectName);
            output.append("Name        : " + name + "\n");
            output.append("State       : " + objState + "\n");
            output.append("Description : " + description + "\n\n");
            outputXML.append("\t<component-info type='binding-component' name='" + name + "' state='" + objState + "'>\n");
            outputXML.append("\t\t<description>");
            outputXML.append(description);
            outputXML.append("</description>\n");
            outputXML.append("\t</component-info>\n");
        }
        outputXML.append("</component-info-list>");
        if (this.xmlOutput == null) {
            try {
                this.log(output.toString());
            }
            catch (NullPointerException e) {}
        } else {
            try {
                this.getProject().setNewProperty(this.xmlOutput, outputXML.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void setBindingComponentName(String bindingComponentName) {
        this.bindingComponentName = bindingComponentName;
    }

    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.serviceAssemblyName = serviceAssemblyName;
    }

    public void setSharedLibraryName(String sharedLibraryName) {
        this.sharedLibraryName = sharedLibraryName;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setXmlOutput(String xmlOutput) {
        this.xmlOutput = xmlOutput;
    }
}

