/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.tools.ant.BuildException;

/**
 * This class is used to install or deploy a JBI component, shared library or
 * service assembly
 * 
 * @author ddesjardins chamerling - eBMWebsourcing
 */
public abstract class AbstractInstallerAntTask extends AbstractJBIAntTask {

    /**
     * Fully qualified installation file path name
     */
    protected String file;

    /**
     * 
     * @param file
     */
    public void setFile(String file) {
        this.file = file;
    }

    /**
     * Validate the file parameter. The file parameter should not be null and
     * must be a jar or a zip archive.
     * 
     * @throws BuildException
     */
    protected URL validateFileParameter() throws BuildException {
        if (file == null) {
            throw new BuildException("Missing attribute 'file'");
        }

        if (file.isEmpty()) {
            throw new BuildException("Empty attribute 'file'");
        }

        if (!file.endsWith(".zip") && !file.endsWith(".jar")) {
            throw new BuildException("File '" + file
                    + "' is not a valid archive (zip or jar required)");
        }

        URL fileURL;
        try {
            fileURL = new URL(file);
        } catch (MalformedURLException e) {
            try {
                fileURL = new File(file).toURI().toURL();
            } catch (MalformedURLException e1) {
                throw new BuildException(
                        "Wrong format for attribute 'file', a valid file location is required");
            }
        }
        return fileURL;
    }

}
