/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.ant;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;

/**
 * This class is used to give the main parameters of the Ant tasks
 *
 * @author ddesjardins chamerling - eBMWebsourcing
 */
public abstract class AbstractJBIAntTask extends Task {

    public static final String DEFAULT_JMX_HOST = "localhost";

    public static final String DEFAULT_JMX_PORT = "7700";

    public static final Pattern saNamepattern = Pattern
            .compile(
                    ".+?<frmwk-task-result>.+?<task-result>(\\w+?)</task-result>.+?<loc-param>(.+?)</loc-param>",
                    Pattern.DOTALL);

    public static final Pattern suResultpattern = Pattern
            .compile(
                    ".+?<component-task-result>.+?<task-result>FAILED</task-result>.+?<loc-param>(.+?)</loc-param>.+?<stack-trace>(.+?)</stack-trace>",
                    Pattern.DOTALL);

    /**
     * Fail on error
     */
    protected boolean failOnError = true;

    /**
     * Host jmx
     */
    protected String host = DEFAULT_JMX_HOST;

    /**
     * Password for security
     */
    protected String password;

    /**
     * Port jmx
     */
    protected String port = DEFAULT_JMX_PORT;

    /**
     * User name for security
     */
    protected String username;

    /**
     * Do the task job
     *
     * @throws Exception
     */
    public abstract void doTask() throws Exception;

    @Override
    public void execute() throws BuildException {

        try {
            doTask();
        } catch (Throwable e) {
            if (isFailOnError()) {
                throw new BuildException(e);
            }
        }
    }

    /**
     * @return the host
     */
    public String getHost() {
        return host;
    }

    /**
     * Get a shared connection to JMX
     *
     * @return
     * @throws IOException
     * @throws ConnectionErrorException
     * @throws NumberFormatException
     */
    public JMXClient getJMXClient() throws NumberFormatException, ConnectionErrorException {
        return new JMXClient(host, Integer.valueOf(port), username, password);
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @return the port
     */
    public String getPort() {
        return port;
    }

    /**
     * @return the username
     */
    public String getUsername() {
        return username;
    }

    /**
     * @return the failOnError
     */
    public boolean isFailOnError() {
        return failOnError;
    }

    /**
     * @param failOnError
     *            the failOnError to set
     */
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    /**
     * @param host
     *            the host to set
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * @param password
     *            the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @param port
     *            the port to set
     */
    public void setPort(String port) {
        this.port = port;
    }

    /**
     * @param username
     *            the username to set
     */
    public void setUsername(String username) {
        this.username = username;
    }

    private final String getConnectionKey() {
        return host + port + username + password;
    }

}
