/**
 * PETALS: PETALS Services Platform Copyright (C) 2005 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.petals.ant.task;

import java.net.URL;
import java.util.regex.Matcher;

import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractInstallerAntTask;

/**
 * Ant task : jbi-deploy-service-assembly. This task deploys a service assembly
 * into the JBI environment.
 * 
 * @author ddesjardins chamerling - eBMWebsourcing
 */
public class DeployServiceAssemblyTask extends AbstractInstallerAntTask {

    /**
     * Creates a new instance of {@link DeployServiceAssemblyTask}
     * 
     */
    public DeployServiceAssemblyTask() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.ant.AbstractJBIAntTask#doTask()
     */
    @Override
    public void doTask() throws Exception {
        URL fileURL = validateFileParameter();

        String serviceAssemblyReport = this.getJMXClient().getDeploymentServiceClient().deploy(
                fileURL);

        boolean isSUfailed = false;

        Matcher matcher = suResultpattern.matcher(serviceAssemblyReport);
        while (matcher.find()) {
            isSUfailed = true;
            log("Failed to deploy SU '" + matcher.group(1) + "':\n" + matcher.group(2),
                    LogLevel.WARN.getLevel());
        }

        matcher = saNamepattern.matcher(serviceAssemblyReport);
        if (matcher.find()) {
            if ("SUCCESS".equals(matcher.group(1).toUpperCase())) {
                if (isSUfailed) {
                    log("Service assembly '" + matcher.group(2)
                            + "' deployed with some SU deployment in failure", LogLevel.WARN
                            .getLevel());
                } else {
                    log("Service Assembly '" + matcher.group(2) + "' deployed");
                }

            } else {
                log("Failed to deploy Service Assembly '" + matcher.group(2) + "'", LogLevel.ERR
                        .getLevel());
            }
        }
    }
}
