/**
 * PETALS: PETALS Services Platform Copyright (C) 2005 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */

package org.ow2.petals.ant.task;

import org.apache.tools.ant.BuildException;
import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : jbi-shut-down-component-task. This task shuts down a particular
 * JBI component in the JBI environment.
 * 
 * @author ddesjardins chamerling - eBMWebsourcing
 */
public class ShutdownComponentTask extends AbstractJBIAntTask {

    /**
     * Name of the JBI component
     */
    private String name;

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.ant.AbstractJBIAntTask#doTask()
     */
    @Override
    public void doTask() throws Exception {
        if (this.name == null) {
            throw new BuildException("Missing attribute 'name'");
        }

        if (this.name.isEmpty()) {
            throw new BuildException("Empty attribute 'name'");
        }

        this.getJMXClient().getInstallationServiceClient().shutdownComponent(this.name);

        log("Component '" + this.name + "' shut down");
    }

    /**
     * Set the name parameter
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

}
