/**
 * PETALS: PETALS Services Platform Copyright (C) 2005 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package org.ow2.petals.ant.task;

import java.util.regex.Matcher;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : jbi-undeploy-service-assembly. This task undeploy a previously
 * deployed service assembly from the JBI environment.
 * 
 * @author ddesjardins chamerling - eBMWebsourcing
 */
public class UndeployServiceAssemblyTask extends AbstractJBIAntTask {

    /**
     * Name of the JBI Service Assembly
     */
    private String name;

    @Override
    public void doTask() throws Exception {
        if (this.name == null) {
            throw new BuildException("Missing attribute 'name'");
        }

        boolean isSUfailed = false;

        String serviceAssemblyReport = this.getJMXClient().getDeploymentServiceClient().undeploy(
                this.name);

        Matcher matcher = suResultpattern.matcher(serviceAssemblyReport);
        while (matcher.find()) {
            isSUfailed = true;
            log("Failed to undeploy SU '" + matcher.group(1) + "':\n" + matcher.group(2),
                    LogLevel.WARN.getLevel());
        }

        matcher = saNamepattern.matcher(serviceAssemblyReport);
        if (matcher.find()) {
            if ("SUCCESS".equals(matcher.group(1).toUpperCase())) {
                if (isSUfailed) {
                    log("Service assembly '" + matcher.group(2)
                            + "' undeployed with some SU undeployment in failure", LogLevel.WARN
                            .getLevel());
                } else {
                    log("Service Assembly '" + matcher.group(2) + "' undeployed");
                }

            } else {
                log("Failed to undeploy Service Assembly '" + matcher.group(2) + "'", LogLevel.ERR
                        .getLevel());
            }
        }
    }

    /**
     * Set the name parameter
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

}
