/**
 * PETALS: PETALS Services Platform Copyright (C) 2007 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package org.ow2.petals.ant.task;

import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : jbi-unload-all-inst. This task unload all components. If the
 * boolean "force" is set to true, components can be uninstalled in all states
 * 
 * @author ofabre
 * 
 */
public class UnloadAllInstallersTask extends AbstractJBIAntTask {

    /**
     * Boolean specifying if installer unloading must be executed in any state
     */
    private boolean force = false;

    @Override
    public void doTask() throws Exception {
        String[] componentNames = this.getJMXClient().getInstallationServiceClient()
                .unloadAllInstallers(force);

        for (String componentName : componentNames) {
            log("Installer of the component '" + componentName + "' unloaded");
        }

    }

    /**
     * set the force parameter
     * 
     * @param force
     */
    public void setForce(boolean force) {
        this.force = force;
    }

}
