/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import org.apache.tools.ant.BuildException;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.ant.AbstractConfigureArchiveAntTask;

public class AbstractConfigureArchiveAntTaskTest {
    @Test
    public void testValidateFileParameter_Null() {
        TestConfigureTask testConfigureTask = new TestConfigureTask();
        try {
            testConfigureTask.validateParam(null, "file");
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException buildException) {
            Assert.assertNotNull((Object)buildException.getMessage());
            Assert.assertTrue((boolean)buildException.getMessage().contains("Missing attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Empty() {
        TestConfigureTask testConfigureTask = new TestConfigureTask();
        try {
            testConfigureTask.validateParam("", "file");
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException buildException) {
            Assert.assertNotNull((Object)buildException.getMessage());
            Assert.assertTrue((boolean)buildException.getMessage().contains("Empty attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Invalid() {
        TestConfigureTask testConfigureTask = new TestConfigureTask();
        try {
            testConfigureTask.validateParam("/tmp/foo", "file");
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException buildException) {
            Assert.assertNotNull((Object)buildException.getMessage());
            Assert.assertTrue((boolean)buildException.getMessage().contains("/tmp/foo"));
            Assert.assertTrue((boolean)buildException.getMessage().contains("is not a valid archive (zip or jar required)"));
        }
    }

    @Test
    public void testValidateFileParameter_JAR() throws BuildException {
        TestConfigureTask testConfigureTask = new TestConfigureTask();
        testConfigureTask.validateParam("/tmp/foo.jar", "file");
    }

    @Test
    public void testValidateFileParameter_ZIP() throws BuildException {
        TestConfigureTask testConfigureTask = new TestConfigureTask();
        testConfigureTask.validateParam("/tmp/foo.zip", "file");
    }

    private class TestConfigureTask
    extends AbstractConfigureArchiveAntTask {
        private TestConfigureTask() {
        }

        public final void validateParam(String string, String string2) throws BuildException {
            AbstractConfigureArchiveAntTask.validateFileParameter((String)string, (String)string2);
        }
    }
}

