/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.ant.AbstractInstallerAntTask;

public class AbstractInstallerAntTaskTest {
    @Test
    public void testValidateFileParameter_Null() {
        FileInstallerAntTask fileInstallerAntTask = new FileInstallerAntTask(null);
        try {
            fileInstallerAntTask.validateFileParameter();
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException buildException) {
            Assert.assertNotNull((Object)buildException.getMessage());
            Assert.assertTrue((boolean)buildException.getMessage().contains("Missing attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Empty() {
        FileInstallerAntTask fileInstallerAntTask = new FileInstallerAntTask("");
        try {
            fileInstallerAntTask.validateFileParameter();
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException buildException) {
            Assert.assertNotNull((Object)buildException.getMessage());
            Assert.assertTrue((boolean)buildException.getMessage().contains("Empty attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Invalid() {
        FileInstallerAntTask fileInstallerAntTask = new FileInstallerAntTask("/tmp/foo");
        try {
            fileInstallerAntTask.validateFileParameter();
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException buildException) {
            Assert.assertNotNull((Object)buildException.getMessage());
            Assert.assertTrue((boolean)buildException.getMessage().contains("/tmp/foo"));
            Assert.assertTrue((boolean)buildException.getMessage().contains("is not a valid archive (zip or jar required)"));
        }
    }

    @Test
    public void testValidateFileParameter_JAR() throws Exception {
        FileInstallerAntTask fileInstallerAntTask = new FileInstallerAntTask("/tmp/foo.jar");
        Assert.assertEquals((Object)new URL("file:/tmp/foo.jar"), (Object)fileInstallerAntTask.validateFileParameter());
    }

    @Test
    public void testValidateFileParameter_ZIP() throws Exception {
        FileInstallerAntTask fileInstallerAntTask = new FileInstallerAntTask("/tmp/foo.zip");
        Assert.assertEquals((Object)new URL("file:/tmp/foo.zip"), (Object)fileInstallerAntTask.validateFileParameter());
    }

    private class FileInstallerAntTask
    extends AbstractInstallerAntTask {
        public FileInstallerAntTask(String string) {
            this.file = string;
        }

        public void doTask() throws Exception {
        }
    }
}

