/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.petals.ant.util.NioUtil;

public class AbstractConfigureArchiveAntTask
extends Task {
    protected static final String JBIDESCRIPTOR_ZIPENTRY_NAME = "META-INF/jbi.xml";
    protected String file;
    protected String outputFile;
    protected boolean overwriteOutputFile = true;

    public void execute() throws BuildException {
        super.execute();
        URL uRL = AbstractConfigureArchiveAntTask.validateFileParameter(this.outputFile, "outputFile");
        try {
            File file = new File(uRL.toURI());
            if (!this.overwriteOutputFile && file.exists()) {
                throw new BuildException("The output component archive '" + this.outputFile + "' already exists.");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new BuildException((Throwable)uRISyntaxException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final File downloadURL(URL uRL) throws IOException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            String string = uRL.getPath();
            String string2 = string.substring(string.lastIndexOf(47) + 1);
            file = File.createTempFile(string2, null);
            inputStream = uRL.openStream();
            NioUtil.copyStreamToFile(inputStream, file);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return file;
    }

    protected static final URL validateFileParameter(String string, String string2) throws BuildException {
        URL uRL;
        if (string == null) {
            throw new BuildException("Missing attribute '" + string2 + "'");
        }
        if (string.isEmpty()) {
            throw new BuildException("Empty attribute '" + string2 + "'");
        }
        if (!string.endsWith(".zip") && !string.endsWith(".jar")) {
            throw new BuildException("File '" + string + "' is not a valid archive (zip or jar required)");
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                throw new BuildException("Wrong format for attribute '" + string2 + "', a valid file location is required");
            }
        }
        return uRL;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public boolean isOverwriteOutputFile() {
        return this.overwriteOutputFile;
    }

    public void setOverwriteOutputFile(boolean bl) {
        this.overwriteOutputFile = bl;
    }
}

