/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.jmx.RuntimeConfigurationComponentClient;

public class ConfigureRuntimeComponentTask
extends AbstractJBIAntTask {
    private static final Hashtable<String, Class<?>> primitiveClasses = new Hashtable(12);
    private String name;
    private List<Param> nestedParams = new ArrayList<Param>();
    private String params;

    public Param createParam() {
        Param param = new Param();
        this.nestedParams.add(param);
        return param;
    }

    @Override
    public void doTask() throws Exception {
        if (this.name == null) {
            throw new BuildException("Missing attribute 'name'");
        }
        Properties properties = this.loadProperties();
        RuntimeConfigurationComponentClient runtimeConfigurationComponentClient = this.getJMXClient().getRuntimeConfigurationClient(this.name);
        this.log(this.nestedParams.size() + properties.size() + " runtime parameters will be set to the component '" + this.name + "'");
        if (runtimeConfigurationComponentClient != null) {
            Map map = runtimeConfigurationComponentClient.getConfigurationMBeanAttributes();
            this.setRuntimeAttributes(map, this.nestedParams, properties);
            runtimeConfigurationComponentClient.setAttributes(map);
            this.log("Runtime configuration of the component '" + this.name + "' set");
        } else {
            this.log("No runtime configuration MBean proposed by the runtime MBean!", LogLevel.WARN.getLevel());
        }
    }

    public List<Param> getNestedParams() {
        return this.nestedParams;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNestedParams(List<Param> list) {
        this.nestedParams = list;
    }

    public void setParams(String string) {
        this.params = string;
    }

    private Param containParam(List<Param> list, String string) {
        for (Param param : list) {
            if (!param.getName().equals(string)) continue;
            return param;
        }
        return null;
    }

    private Param containParam(Properties properties, String string) {
        for (Object object : properties.keySet()) {
            if (!string.equals((String)object)) continue;
            return new Param((String)object, (String)properties.get(object));
        }
        return null;
    }

    private Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        if (this.params != null) {
            properties.load(new FileInputStream(this.params));
        }
        return properties;
    }

    private void setRuntimeAttributes(Map<MBeanAttributeInfo, Object> map, List<Param> list, Properties properties) {
        Set<Map.Entry<MBeanAttributeInfo, Object>> set = map.entrySet();
        for (Map.Entry<MBeanAttributeInfo, Object> entry : set) {
            Param param = this.containParam(this.nestedParams, entry.getKey().getName());
            if (param == null) {
                param = this.containParam(properties, entry.getKey().getName());
                if (param != null) {
                    this.log("Setting attribute from properties " + param.getName() + " = " + param.getValue());
                }
            } else {
                this.log("Setting attribute " + param.getName() + " = " + param.getValue());
            }
            if (param == null) continue;
            Object object = null;
            if (primitiveClasses.containsKey(entry.getKey().getType())) {
                try {
                    Class<?> clazz = primitiveClasses.get(entry.getKey().getType());
                    Method method = clazz.getMethod("valueOf", String.class);
                    object = method.invoke(null, param.getValue());
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
            } else if (entry.getKey().getType().equals(String.class.getName())) {
                object = param.getValue();
            }
            if (object == null) {
                throw new RuntimeException("Failed to identify primitive type '" + entry.getKey().getType() + "' of parameter '" + entry.getKey().getName() + "'");
            }
            entry.setValue(object);
        }
    }

    static {
        primitiveClasses.put(Boolean.class.getName(), Boolean.class);
        primitiveClasses.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveClasses.put(Short.class.getName(), Short.class);
        primitiveClasses.put(Short.TYPE.getName(), Short.class);
        primitiveClasses.put(Integer.class.getName(), Integer.class);
        primitiveClasses.put(Integer.TYPE.getName(), Integer.class);
        primitiveClasses.put(Long.class.getName(), Long.class);
        primitiveClasses.put(Long.TYPE.getName(), Long.class);
        primitiveClasses.put(Float.class.getName(), Float.class);
        primitiveClasses.put(Float.TYPE.getName(), Float.class);
        primitiveClasses.put(Double.class.getName(), Double.class);
        primitiveClasses.put(Double.TYPE.getName(), Double.class);
    }

    public static class Param {
        private String name;
        private String value;

        public Param() {
            this("", "");
        }

        public Param(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

