/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractConfigureArchiveAntTask;
import org.ow2.petals.ant.util.NioUtil;
import org.ow2.petals.ant.util.ZipUtil;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.w3c.dom.Element;

public class ConfigureServiceAssemblyTask
extends AbstractConfigureArchiveAntTask {
    private static final String CDK_NAMESPACE_PREFIX = "http://petals.ow2.org/components/extensions";
    private static final String COMPONENT_NAMESPACE_PREFIX = "http://petals.ow2.org/components/";
    private String identification;
    private final List<ServiceUnit> serviceUnits = new ArrayList<ServiceUnit>();
    private String suProperties;

    public ServiceUnit createServiceUnit() {
        ServiceUnit serviceUnit = new ServiceUnit();
        this.serviceUnits.add(serviceUnit);
        return serviceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() throws BuildException {
        super.execute();
        try {
            this.loadServiceUnitProperties();
            URL uRL = ConfigureServiceAssemblyTask.validateFileParameter(this.file, "file");
            File file = ConfigureServiceAssemblyTask.downloadURL(uRL);
            try {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry zipEntry = zipFile.getEntry("META-INF/jbi.xml");
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                final Jbi jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)inputStream);
                inputStream.close();
                if (this.identification != null) {
                    jbi.getServiceAssembly().getIdentification().setName(this.identification);
                }
                HashMap hashMap = new HashMap();
                for (ServiceUnit object2 : this.serviceUnits) {
                    void var10_16;
                    if (object2.identification == null) {
                        throw new BuildException("Missing attribute 'identification' in a Service Unit element");
                    }
                    if (object2.param == null) {
                        throw new BuildException("Missing attribute 'param' in a Service Unit element");
                    }
                    if (object2.value == null) {
                        throw new BuildException("Missing attribute 'value' in a Service Unit element");
                    }
                    List list = (List)hashMap.get(object2.identification);
                    if (list == null) {
                        ArrayList arrayList = new ArrayList();
                        hashMap.put(object2.identification, arrayList);
                    }
                    var10_16.add(new _ServiceUnit(object2.endpoint, object2.param, object2.value));
                }
                for (org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit serviceUnit : jbi.getServiceAssembly().getServiceUnit()) {
                    List list = (List)hashMap.get(serviceUnit.getIdentification().getName());
                    if (list == null) continue;
                    ((_ServiceUnit)list.get((int)0)).suZipName = serviceUnit.getTarget().getArtifactsZip();
                    ((_ServiceUnit)list.get((int)0)).suName = serviceUnit.getIdentification().getName();
                }
                final HashMap hashMap2 = new HashMap();
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (((_ServiceUnit)((List)entry.getValue()).get((int)0)).suZipName != null) {
                        this.updateServiceUnit((List)entry.getValue(), hashMap2, zipFile);
                        continue;
                    }
                    this.log("The Service Unit with identification '" + (String)entry.getKey() + "' do not exist in the target Service Assembly", LogLevel.WARN.getLevel());
                }
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.outputFile));
                ZipUtil.copyAndUpdateZipFile(zipFile, zipOutputStream, new ZipUtil.ZipEntryCallback(){

                    @Override
                    public InputStream onZipEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException, JBIDescriptorException {
                        if (hashMap2.containsKey(zipEntry.getName())) {
                            return (InputStream)hashMap2.get(zipEntry.getName());
                        }
                        if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                            String string = JBIDescriptorBuilder.buildXmlStringJBIdescriptor((Jbi)jbi);
                            return new ByteArrayInputStream(string.getBytes());
                        }
                        return inputStream;
                    }
                });
                zipOutputStream.flush();
                zipOutputStream.close();
            }
            finally {
                file.delete();
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        catch (JBIDescriptorException jBIDescriptorException) {
            throw new BuildException((Throwable)jBIDescriptorException);
        }
    }

    public String getIdentification() {
        return this.identification;
    }

    public String getSuProperties() {
        return this.suProperties;
    }

    public void setIdentification(String string) {
        this.identification = string;
    }

    public void setSuProperties(String string) {
        this.suProperties = string;
    }

    private String[] analyseSplittedKeys(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            while (string.endsWith("\\")) {
                string = string.substring(0, string.length() - 1);
                string = string + "." + stringArray[++i];
            }
            stringArray2[n++] = string;
        }
        String[] stringArray3 = new String[n];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        return stringArray3;
    }

    private void loadServiceUnitProperties() throws IOException {
        Properties properties = new Properties();
        if (this.suProperties != null) {
            properties.load(new FileInputStream(this.suProperties));
        }
        for (Object object : properties.keySet()) {
            String string = (String)object;
            String[] stringArray = string.split("\\.");
            String[] stringArray2 = this.analyseSplittedKeys(stringArray);
            if (stringArray2.length < 2 || stringArray2.length > 4) {
                throw new BuildException("Unexpected property name. Name must be in the form su-name.[endpoint-name].['cdk'|'component'].parameter-name=parameter-value");
            }
            ServiceUnit serviceUnit = new ServiceUnit();
            serviceUnit.setIdentification(stringArray2[0]);
            if (stringArray2.length == 2) {
                serviceUnit.setParam(stringArray2[1]);
            } else if (stringArray2.length == 3) {
                if (stringArray2[1].equals("cdk") || stringArray2[1].equals("component")) {
                    serviceUnit.setParam(stringArray2[1] + "." + stringArray2[2]);
                } else {
                    serviceUnit.setEndpoint(stringArray2[1]);
                    serviceUnit.setParam(stringArray2[2]);
                }
            } else {
                serviceUnit.setEndpoint(stringArray2[1]);
                serviceUnit.setParam(stringArray2[2] + "." + stringArray2[3]);
            }
            serviceUnit.setValue((String)properties.get(object));
            this.serviceUnits.add(serviceUnit);
        }
    }

    private final boolean updateParameter(List<Element> list, String string, String string2, String string3, String string4) {
        boolean bl = false;
        for (Element element : list) {
            if (string != null && (!element.getNamespaceURI().startsWith(string) || string.equals(COMPONENT_NAMESPACE_PREFIX) && element.getNamespaceURI().startsWith(CDK_NAMESPACE_PREFIX)) || !element.getLocalName().equals(string2)) continue;
            element.setTextContent(string3);
            bl = true;
            this.log("Parameter '" + string2 + "' set to value '" + string3 + "' in the Service Unit '" + string4 + "'");
            break;
        }
        return bl;
    }

    private void updateServiceUnit(List<_ServiceUnit> list, Map<String, InputStream> map, ZipFile zipFile) throws IOException, JBIDescriptorException {
        ZipOutputStream zipOutputStream2;
        String string = list.get((int)0).suZipName;
        String string2 = list.get((int)0).suName;
        ZipEntry zipEntry = zipFile.getEntry(string);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        File file = File.createTempFile(string, null);
        NioUtil.copyStreamToFile(inputStream, file);
        ZipFile zipFile2 = new ZipFile(file);
        ZipEntry zipEntry2 = zipFile2.getEntry("META-INF/jbi.xml");
        InputStream inputStream2 = zipFile2.getInputStream(zipEntry2);
        Jbi jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)inputStream2);
        String string3 = null;
        for (_ServiceUnit object2 : list) {
            boolean bl = false;
            if (object2.param.startsWith("cdk.")) {
                string3 = CDK_NAMESPACE_PREFIX;
                object2.param = object2.param.substring(4);
            } else if (object2.param.startsWith("component.")) {
                string3 = COMPONENT_NAMESPACE_PREFIX;
                object2.param = object2.param.substring(10);
            }
            for (ZipOutputStream zipOutputStream2 : jbi.getServices().getConsumes()) {
                if (object2.endpoint != null && !object2.endpoint.equals(zipOutputStream2.getEndpointName()) || !(bl = this.updateParameter(zipOutputStream2.getAnyOrAny(), string3, object2.param, object2.value, string2))) continue;
                break;
            }
            if (!bl) {
                for (ZipOutputStream zipOutputStream2 : jbi.getServices().getProvides()) {
                    if (object2.endpoint != null && !object2.endpoint.equals(zipOutputStream2.getEndpointName()) || !(bl = this.updateParameter(zipOutputStream2.getAnyOrAny(), string3, object2.param, object2.value, string2))) continue;
                    break;
                }
            }
            if (bl) continue;
            this.log("Failed to find parameter '" + object2.param + "' in the Service Unit '" + string2 + "'", LogLevel.WARN.getLevel());
        }
        String string4 = JBIDescriptorBuilder.buildXmlStringJBIdescriptor((Jbi)jbi);
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string4.getBytes());
        Iterator iterator = File.createTempFile(string.substring(0, string.length() - 4), ".zip");
        zipOutputStream2 = new ZipOutputStream(new FileOutputStream((File)((Object)iterator)));
        ZipUtil.copyAndUpdateZipFile(new ZipFile(file), zipOutputStream2, new ZipUtil.ZipEntryCallback(){

            @Override
            public InputStream onZipEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException, JBIDescriptorException {
                if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                    return byteArrayInputStream;
                }
                return inputStream;
            }
        });
        zipOutputStream2.flush();
        zipOutputStream2.close();
        map.put(string, new FileInputStream((File)((Object)iterator)));
    }

    private static final class _ServiceUnit {
        public String endpoint;
        public String param;
        public String suName;
        public String suZipName;
        public String value;

        public _ServiceUnit(String string, String string2, String string3) {
            this.endpoint = string;
            this.param = string2;
            this.value = string3;
        }
    }

    public static final class ServiceUnit {
        private String endpoint;
        private String identification;
        private String param;
        private String value;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getIdentification() {
            return this.identification;
        }

        public String getParam() {
            return this.param;
        }

        public String getValue() {
            return this.value;
        }

        public void setEndpoint(String string) {
            this.endpoint = string;
        }

        public void setIdentification(String string) {
            this.identification = string;
        }

        public void setParam(String string) {
            this.param = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

