/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractInstallerAntTask;
import org.ow2.petals.ant.task.primitive.PrimitiveConverter;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterBoolean;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterDouble;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterFloat;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterInteger;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterLong;
import org.ow2.petals.ant.task.primitive.PrimitiveConverterShort;
import org.ow2.petals.jmx.ConfigurationInstallerComponentClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.exception.AttributeErrorException;

public class InstallComponentTask
extends AbstractInstallerAntTask {
    private static final Map<String, PrimitiveConverter> primitiveClasses = new Hashtable<String, PrimitiveConverter>();
    private Set<MBeanAttributeInfo> configurationAttributes;
    private final List<Param> nestedParams = new ArrayList<Param>();
    private String params;

    public Param createParam() {
        Param param = new Param();
        this.nestedParams.add(param);
        return param;
    }

    @Override
    public void doTask() throws Exception {
        URL uRL = this.validateFileParameter();
        InstallerComponentClient installerComponentClient = this.getJMXClient().getInstallationServiceClient().loadNewInstaller(uRL);
        Properties properties = this.loadProperties();
        if (this.nestedParams.size() > 0 || properties.size() > 0) {
            this.log(this.nestedParams.size() + properties.size() + " installation parameters will be set to the installer");
            ConfigurationInstallerComponentClient configurationInstallerComponentClient = installerComponentClient.getConfigurationInstallerClient();
            if (configurationInstallerComponentClient != null) {
                this.configurationAttributes = configurationInstallerComponentClient.getAttributes().keySet();
                this.setConnectionAttributeFromNestedParam(configurationInstallerComponentClient);
                this.setConnectionAttributeFromPropertiesFile(configurationInstallerComponentClient, properties);
            } else {
                this.log("No installer configuration MBean proposed by the installer MBean!", LogLevel.WARN.getLevel());
            }
        }
        installerComponentClient.install();
        this.log("Component '" + installerComponentClient.getMBeanName().getKeyProperty("name") + "' installed");
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String string) {
        this.params = string;
    }

    private Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        if (this.params != null) {
            properties.load(new FileInputStream(this.params));
        }
        return properties;
    }

    private void setAttribute(ConfigurationInstallerComponentClient configurationInstallerComponentClient, String string, String string2) throws AttributeErrorException {
        Object object = null;
        boolean bl = false;
        for (MBeanAttributeInfo mBeanAttributeInfo : this.configurationAttributes) {
            if (!mBeanAttributeInfo.getName().equals(string)) continue;
            if (primitiveClasses.containsKey(mBeanAttributeInfo.getType())) {
                PrimitiveConverter primitiveConverter = primitiveClasses.get(mBeanAttributeInfo.getType());
                try {
                    object = primitiveConverter.convert(string2);
                }
                catch (BuildException buildException) {
                    throw new BuildException("Invalid value for attribute '" + string + "': " + buildException.getMessage());
                }
            } else if (mBeanAttributeInfo.getType().equals(String.class.getName())) {
                object = string2;
            }
            bl = true;
            break;
        }
        if (object == null) {
            if (bl) {
                throw new RuntimeException("Failed to identify primitive type of parameter '" + string + "'");
            }
            throw new RuntimeException("Failed to identify parameter '" + string + "'");
        }
        configurationInstallerComponentClient.setAttribute(string, object);
    }

    private void setConnectionAttributeFromNestedParam(ConfigurationInstallerComponentClient configurationInstallerComponentClient) throws Exception {
        for (Param param : this.nestedParams) {
            this.log("Setting attribute " + param.getName() + " = " + param.getValue());
            this.setAttribute(configurationInstallerComponentClient, param.getName(), param.getValue());
        }
    }

    private void setConnectionAttributeFromPropertiesFile(ConfigurationInstallerComponentClient configurationInstallerComponentClient, Properties properties) throws Exception {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.log("Setting attribute from properties " + (String)entry.getKey() + " = " + (String)entry.getValue());
            this.setAttribute(configurationInstallerComponentClient, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    static {
        primitiveClasses.put(Boolean.class.getName(), new PrimitiveConverterBoolean());
        primitiveClasses.put(Boolean.TYPE.getName(), new PrimitiveConverterBoolean());
        primitiveClasses.put(Short.class.getName(), new PrimitiveConverterShort());
        primitiveClasses.put(Short.TYPE.getName(), new PrimitiveConverterShort());
        primitiveClasses.put(Integer.class.getName(), new PrimitiveConverterInteger());
        primitiveClasses.put(Integer.TYPE.getName(), new PrimitiveConverterInteger());
        primitiveClasses.put(Long.class.getName(), new PrimitiveConverterLong());
        primitiveClasses.put(Long.TYPE.getName(), new PrimitiveConverterLong());
        primitiveClasses.put(Float.class.getName(), new PrimitiveConverterFloat());
        primitiveClasses.put(Float.TYPE.getName(), new PrimitiveConverterFloat());
        primitiveClasses.put(Double.class.getName(), new PrimitiveConverterDouble());
        primitiveClasses.put(Double.TYPE.getName(), new PrimitiveConverterDouble());
    }

    public static class Param {
        private String name;
        private String value;

        public Param() {
            this("", "");
        }

        public Param(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

