/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;

public class ZipUtil {
    public static final void addFile(ZipOutputStream zipOutputStream, InputStream inputStream, String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        ZipUtil.putEntry(zipOutputStream, inputStream, zipEntry);
    }

    public static final void addFile(ZipOutputStream zipOutputStream, InputStream inputStream, String string, long l) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l);
        ZipUtil.putEntry(zipOutputStream, inputStream, zipEntry);
    }

    public static final void copyAndUpdateZipFile(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntryCallback zipEntryCallback) throws IOException, JBIDescriptorException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
            zipEntry2.setComment(zipEntry.getComment());
            zipEntry2.setTime(zipEntry.getTime());
            ZipUtil.putEntry(zipOutputStream, zipEntryCallback.onZipEntry(zipEntry2, zipFile.getInputStream(zipEntry)), zipEntry2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void putEntry(ZipOutputStream zipOutputStream, InputStream inputStream, ZipEntry zipEntry) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
        }
        finally {
            dataInputStream.close();
        }
    }

    public static interface ZipEntryCallback {
        public InputStream onZipEntry(ZipEntry var1, InputStream var2) throws IOException, JBIDescriptorException;
    }
}

