/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractConfigureArchiveAntTask;
import org.ow2.petals.ant.util.NioUtil;
import org.ow2.petals.ant.util.ZipUtil;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Consumes;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.Provides;
import org.w3c.dom.Element;

public class ConfigureServiceAssemblyTask
extends AbstractConfigureArchiveAntTask {
    private static final String CDK_NAMESPACE_PREFIX = "http://petals.ow2.org/components/extensions";
    private static final String COMPONENT_NAMESPACE_PREFIX = "http://petals.ow2.org/components/";
    private String identification;
    private final List<ServiceUnit> serviceUnits = new ArrayList<ServiceUnit>();
    private String suProperties;

    public ServiceUnit createServiceUnit() {
        ServiceUnit serviceUnit = new ServiceUnit();
        this.serviceUnits.add(serviceUnit);
        return serviceUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        super.execute();
        try {
            this.loadServiceUnitProperties();
            URL saUrl = ConfigureServiceAssemblyTask.validateFileParameter(this.file, "file");
            File saFile = ConfigureServiceAssemblyTask.downloadURL(saUrl);
            try {
                List<_ServiceUnit> _serviceUnitList;
                ZipFile saZip = new ZipFile(saFile);
                ZipEntry jbiZipEntry = saZip.getEntry("META-INF/jbi.xml");
                InputStream jbiInputStream = saZip.getInputStream(jbiZipEntry);
                final Jbi saJbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)jbiInputStream);
                jbiInputStream.close();
                if (this.identification != null) {
                    saJbi.getServiceAssembly().getIdentification().setName(this.identification);
                }
                HashMap<String, ArrayList<_ServiceUnit>> _serviceUnits = new HashMap<String, ArrayList<_ServiceUnit>>();
                for (ServiceUnit serviceUnit : this.serviceUnits) {
                    if (serviceUnit.identification == null) {
                        throw new BuildException("Missing attribute 'identification' in a Service Unit element");
                    }
                    if (serviceUnit.param == null) {
                        throw new BuildException("Missing attribute 'param' in a Service Unit element");
                    }
                    if (serviceUnit.value == null) {
                        throw new BuildException("Missing attribute 'value' in a Service Unit element");
                    }
                    _serviceUnitList = (ArrayList<_ServiceUnit>)_serviceUnits.get(serviceUnit.identification);
                    if (_serviceUnitList == null) {
                        _serviceUnitList = new ArrayList<_ServiceUnit>();
                        _serviceUnits.put(serviceUnit.identification, (ArrayList<_ServiceUnit>)_serviceUnitList);
                    }
                    _serviceUnitList.add(new _ServiceUnit(serviceUnit.endpoint, serviceUnit.param, serviceUnit.value));
                }
                for (org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit extractServiceUnit : saJbi.getServiceAssembly().getServiceUnit()) {
                    _serviceUnitList = (List)_serviceUnits.get(extractServiceUnit.getIdentification().getName());
                    if (_serviceUnitList == null) continue;
                    ((_ServiceUnit)_serviceUnitList.get((int)0)).suZipName = extractServiceUnit.getTarget().getArtifactsZip();
                    ((_ServiceUnit)_serviceUnitList.get((int)0)).suName = extractServiceUnit.getIdentification().getName();
                }
                final HashMap<String, InputStream> udpatedSuFiles = new HashMap<String, InputStream>();
                for (Map.Entry _serviceUnitEntry : _serviceUnits.entrySet()) {
                    if (((_ServiceUnit)((List)_serviceUnitEntry.getValue()).get((int)0)).suZipName != null) {
                        this.updateServiceUnit((List)_serviceUnitEntry.getValue(), udpatedSuFiles, saZip);
                        continue;
                    }
                    this.log("The Service Unit with identification '" + (String)_serviceUnitEntry.getKey() + "' do not exist in the target Service Assembly", LogLevel.WARN.getLevel());
                }
                ZipOutputStream zipOutputFile = new ZipOutputStream(new FileOutputStream(this.outputFile));
                ZipUtil.copyAndUpdateZipFile(saZip, zipOutputFile, new ZipUtil.ZipEntryCallback(){

                    @Override
                    public InputStream onZipEntry(ZipEntry zipEntry, InputStream zipEntryInputStream) throws IOException, JBIDescriptorException {
                        if (udpatedSuFiles.containsKey(zipEntry.getName())) {
                            return (InputStream)udpatedSuFiles.get(zipEntry.getName());
                        }
                        if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            JBIDescriptorBuilder.writeJBIdescriptor((Jbi)saJbi, (OutputStream)baos);
                            return new ByteArrayInputStream(baos.toByteArray());
                        }
                        return zipEntryInputStream;
                    }
                });
                zipOutputFile.flush();
                zipOutputFile.close();
            }
            finally {
                saFile.delete();
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (JBIDescriptorException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String getIdentification() {
        return this.identification;
    }

    public String getSuProperties() {
        return this.suProperties;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public void setSuProperties(String suProperties) {
        this.suProperties = suProperties;
    }

    private String[] analyseSplittedKeys(String[] splittedKey) {
        String[] newSplittedKeys = new String[splittedKey.length];
        int j = 0;
        for (int i = 0; i < splittedKey.length; ++i) {
            String key = splittedKey[i];
            while (key.endsWith("\\")) {
                key = key.substring(0, key.length() - 1);
                key = key + "." + splittedKey[++i];
            }
            newSplittedKeys[j++] = key;
        }
        String[] correctedSplittedKeys = new String[j];
        for (int k = 0; k < correctedSplittedKeys.length; ++k) {
            correctedSplittedKeys[k] = newSplittedKeys[k];
        }
        return correctedSplittedKeys;
    }

    private void loadServiceUnitProperties() throws IOException {
        Properties props = new Properties();
        if (this.suProperties != null) {
            props.load(new FileInputStream(this.suProperties));
        }
        for (Object key : props.keySet()) {
            String keyString = (String)key;
            String[] splittedKey = keyString.split("\\.");
            String[] correctedSplittedKeys = this.analyseSplittedKeys(splittedKey);
            if (correctedSplittedKeys.length < 2 || correctedSplittedKeys.length > 4) {
                throw new BuildException("Unexpected property name. Name must be in the form su-name.[endpoint-name].['cdk'|'component'].parameter-name=parameter-value");
            }
            ServiceUnit serviceUnit = new ServiceUnit();
            serviceUnit.setIdentification(correctedSplittedKeys[0]);
            if (correctedSplittedKeys.length == 2) {
                serviceUnit.setParam(correctedSplittedKeys[1]);
            } else if (correctedSplittedKeys.length == 3) {
                if (correctedSplittedKeys[1].equals("cdk") || correctedSplittedKeys[1].equals("component")) {
                    serviceUnit.setParam(correctedSplittedKeys[1] + "." + correctedSplittedKeys[2]);
                } else {
                    serviceUnit.setEndpoint(correctedSplittedKeys[1]);
                    serviceUnit.setParam(correctedSplittedKeys[2]);
                }
            } else {
                serviceUnit.setEndpoint(correctedSplittedKeys[1]);
                serviceUnit.setParam(correctedSplittedKeys[2] + "." + correctedSplittedKeys[3]);
            }
            serviceUnit.setValue((String)props.get(key));
            this.serviceUnits.add(serviceUnit);
        }
    }

    private final boolean updateParameter(List<Element> elements, String namespace, String param, String value, String suName) {
        boolean found = false;
        for (Element element : elements) {
            if (namespace != null && (!element.getNamespaceURI().startsWith(namespace) || namespace.equals(COMPONENT_NAMESPACE_PREFIX) && element.getNamespaceURI().startsWith(CDK_NAMESPACE_PREFIX)) || !element.getLocalName().equals(param)) continue;
            element.setTextContent(value);
            found = true;
            this.log("Parameter '" + param + "' set to value '" + value + "' in the Service Unit '" + suName + "'");
            break;
        }
        return found;
    }

    private void updateServiceUnit(List<_ServiceUnit> _serviceUnitList, Map<String, InputStream> udpatedSuFiles, ZipFile saZip) throws IOException, JBIDescriptorException {
        String suZipName = _serviceUnitList.get((int)0).suZipName;
        String suName = _serviceUnitList.get((int)0).suName;
        ZipEntry suZipEntry = saZip.getEntry(suZipName);
        InputStream suInputStream = saZip.getInputStream(suZipEntry);
        File suTempFile = File.createTempFile(suZipName, null);
        NioUtil.copyStreamToFile(suInputStream, suTempFile);
        ZipFile suTempZip = new ZipFile(suTempFile);
        ZipEntry suJbiZipEntry = suTempZip.getEntry("META-INF/jbi.xml");
        InputStream suJbiInputStream = suTempZip.getInputStream(suJbiZipEntry);
        Jbi suJbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)suJbiInputStream);
        String namespace = null;
        for (_ServiceUnit _serviceUnit : _serviceUnitList) {
            boolean found = false;
            if (_serviceUnit.param.startsWith("cdk.")) {
                namespace = CDK_NAMESPACE_PREFIX;
                _serviceUnit.param = _serviceUnit.param.substring(4);
            } else if (_serviceUnit.param.startsWith("component.")) {
                namespace = COMPONENT_NAMESPACE_PREFIX;
                _serviceUnit.param = _serviceUnit.param.substring(10);
            }
            for (Consumes consumes : suJbi.getServices().getConsumes()) {
                if (_serviceUnit.endpoint != null && !_serviceUnit.endpoint.equals(consumes.getEndpointName()) || !(found = this.updateParameter(consumes.getAnyOrAny(), namespace, _serviceUnit.param, _serviceUnit.value, suName))) continue;
                break;
            }
            if (!found) {
                for (Provides provides : suJbi.getServices().getProvides()) {
                    if (_serviceUnit.endpoint != null && !_serviceUnit.endpoint.equals(provides.getEndpointName()) || !(found = this.updateParameter(provides.getAnyOrAny(), namespace, _serviceUnit.param, _serviceUnit.value, suName))) continue;
                    break;
                }
            }
            if (found) continue;
            this.log("Failed to find parameter '" + _serviceUnit.param + "' in the Service Unit '" + suName + "'", LogLevel.WARN.getLevel());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JBIDescriptorBuilder.writeJBIdescriptor((Jbi)suJbi, (OutputStream)baos);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        File suFile = File.createTempFile(suZipName.substring(0, suZipName.length() - 4), ".zip");
        ZipOutputStream zipOutputFile = new ZipOutputStream(new FileOutputStream(suFile));
        ZipUtil.copyAndUpdateZipFile(new ZipFile(suTempFile), zipOutputFile, new ZipUtil.ZipEntryCallback(){

            @Override
            public InputStream onZipEntry(ZipEntry zipEntry, InputStream zipEntryInputStream) throws IOException, JBIDescriptorException {
                if ("META-INF/jbi.xml".equals(zipEntry.getName())) {
                    return inputStream;
                }
                return zipEntryInputStream;
            }
        });
        zipOutputFile.flush();
        zipOutputFile.close();
        udpatedSuFiles.put(suZipName, new FileInputStream(suFile));
    }

    private static final class _ServiceUnit {
        public String endpoint;
        public String param;
        public String suName;
        public String suZipName;
        public String value;

        public _ServiceUnit(String endpoint, String param, String value) {
            this.endpoint = endpoint;
            this.param = param;
            this.value = value;
        }
    }

    public static final class ServiceUnit {
        private String endpoint;
        private String identification;
        private String param;
        private String value;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getIdentification() {
            return this.identification;
        }

        public String getParam() {
            return this.param;
        }

        public String getValue() {
            return this.value;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setIdentification(String identification) {
            this.identification = identification;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

