/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.AdminDoesNotExistException;
import org.ow2.petals.jmx.exception.AdminServiceErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public class AdminServiceClient
extends AbstractServiceClient {
    private static final String GET_SYSTEM_INFO = "getSystemInfo";
    private static final String GET_BINDING_COMPONENTS = "getBindingComponents";
    private static final String GET_ENGINE_COMPONENTS = "getEngineComponents";
    private static final String GET_COMPONENT_BY_NAME = "getComponentByName";
    private static final String ADMIN_SERVICE_JMX_NAME = "Admin";

    public AdminServiceClient(String petalsDomain, MBeanServerConnection beanServerConnection) throws AdminDoesNotExistException, AdminServiceErrorException {
        super(petalsDomain, beanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", ADMIN_SERVICE_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new AdminDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new AdminServiceErrorException(e);
        }
        catch (IOException e) {
            throw new AdminServiceErrorException(e);
        }
    }

    public String getSystemInfo() throws AdminServiceErrorException {
        String result;
        try {
            result = (String)this.performAction(GET_SYSTEM_INFO, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new AdminServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new AdminServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public ObjectName[] getBindingComponents() throws AdminServiceErrorException {
        ObjectName[] components;
        try {
            components = (ObjectName[])this.performAction(GET_BINDING_COMPONENTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new AdminServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new AdminServiceErrorException("Unexpected result type");
        }
        return components;
    }

    public ObjectName[] getEngineComponents() throws AdminServiceErrorException {
        ObjectName[] components;
        try {
            components = (ObjectName[])this.performAction(GET_ENGINE_COMPONENTS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new AdminServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new AdminServiceErrorException("Unexpected result type");
        }
        return components;
    }

    public ObjectName getComponentByName(String component) throws AdminServiceErrorException {
        ObjectName componentName;
        Object[] objectsLoad = new Object[]{component};
        String[] stringsLoad = new String[]{String.class.getName()};
        try {
            componentName = (ObjectName)this.performAction(GET_COMPONENT_BY_NAME, objectsLoad, stringsLoad);
        }
        catch (PerformActionErrorException e) {
            throw new AdminServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new AdminServiceErrorException("Unexpected result type");
        }
        return componentName;
    }
}

