/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.AttributeErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;
import org.ow2.petals.jmx.exception.SystemMonitoringDoesNotExistException;
import org.ow2.petals.jmx.exception.SystemMonitoringServiceErrorException;

public class SystemMonitoringServiceClient
extends AbstractServiceClient {
    protected static final String LOADED_CLASS_COUNT = "LoadedClassCount";
    protected static final String TOTAL_LOADED_CLASS_COUNT = "TotalLoadedClassCount";
    protected static final String UNLOADED_CLASS_COUNT = "UnloadedClassCount";
    protected static final String UP_TIME = "Uptime";
    protected static final String PEAK_THREAD_COUNT = "PeakThreadCount";
    protected static final String DAEMON_THREAD_COUNT = "DaemonThreadCount";
    protected static final String THREAD_COUNT = "ThreadCount";
    protected static final String TOTAL_STARTED_THREAD_COUNT = "TotalStartedThreadCount";
    protected static final String HEAP_MEMORY_USAGE = "HeapMemoryUsage";
    protected static final String OBJECT_PENDING_FINALIZATION_COUNT = "ObjectPendingFinalizationCount";
    protected static final String AVAILABLE_PROCESSORS = "AvailableProcessors";
    protected static final String PROCESS_CPU_TIME = "ProcessCpuTime";
    protected static final String TOTAL_PHYSICAL_MEMORY_SIZE = "TotalPhysicalMemorySize";
    protected static final String FREE_PHYSICAL_MEMORY_SIZE = "FreePhysicalMemorySize";
    protected static final String COMMITTED_VIRTUAL_MEMORY_SIZE = "CommittedVirtualMemorySize";
    private static final String OPERATING_SYSTEM = "OperatingSystem";
    private static final String RUNTIME = "Runtime";
    private static final String THREADING = "Threading";
    private static final String MEMORY = "Memory";
    private static final String CLASS_LOADING = "ClassLoading";
    private ObjectName operatingSystemMBeanName;
    private ObjectName runtimeMBeanName;
    private ObjectName threadingMBeanName;
    private ObjectName memoryMBeanName;
    private ObjectName classLoadingMBeanName;

    public SystemMonitoringServiceClient(String domain, MBeanServerConnection beanServerConnection) throws SystemMonitoringDoesNotExistException, SystemMonitoringServiceErrorException {
        super(domain, beanServerConnection);
        try {
            ObjectName objName = new ObjectName(domain + ":*");
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            for (ObjectName bean : objNames) {
                if (bean.getCanonicalName().equalsIgnoreCase(domain + ":" + "type" + "=" + OPERATING_SYSTEM)) {
                    this.operatingSystemMBeanName = bean;
                    continue;
                }
                if (bean.getCanonicalName().equalsIgnoreCase(domain + ":" + "type" + "=" + RUNTIME)) {
                    this.runtimeMBeanName = bean;
                    continue;
                }
                if (bean.getCanonicalName().equalsIgnoreCase(domain + ":" + "type" + "=" + THREADING)) {
                    this.threadingMBeanName = bean;
                    continue;
                }
                if (bean.getCanonicalName().equalsIgnoreCase(domain + ":" + "type" + "=" + MEMORY)) {
                    this.memoryMBeanName = bean;
                    continue;
                }
                if (!bean.getCanonicalName().equalsIgnoreCase(domain + ":" + "type" + "=" + CLASS_LOADING)) continue;
                this.classLoadingMBeanName = bean;
            }
            if (this.operatingSystemMBeanName == null) {
                throw new SystemMonitoringDoesNotExistException("Can't find OperatingSystem bean");
            }
            if (this.runtimeMBeanName == null) {
                throw new SystemMonitoringDoesNotExistException("Can't find Runtime bean");
            }
            if (this.threadingMBeanName == null) {
                throw new SystemMonitoringDoesNotExistException("Can't find Threading bean");
            }
            if (this.memoryMBeanName == null) {
                throw new SystemMonitoringDoesNotExistException("Can't find Memory bean");
            }
            if (this.classLoadingMBeanName == null) {
                throw new SystemMonitoringDoesNotExistException("Can't find ClassLoading bean");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new SystemMonitoringServiceErrorException(e);
        }
        catch (IOException e) {
            throw new SystemMonitoringServiceErrorException(e);
        }
    }

    public CompositeDataSupport getHeapMemoryUsage() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.memoryMBeanName, HEAP_MEMORY_USAGE);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof CompositeDataSupport)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (CompositeDataSupport)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public int getPendingObjects() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.memoryMBeanName, OBJECT_PENDING_FINALIZATION_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Integer)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Integer)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public int getPeakThreadCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.threadingMBeanName, PEAK_THREAD_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Integer)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Integer)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public int getDaemonThreadCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.threadingMBeanName, DAEMON_THREAD_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Integer)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Integer)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public int getThreadCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.threadingMBeanName, THREAD_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Integer)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Integer)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getTotalStartedThreadCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.threadingMBeanName, TOTAL_STARTED_THREAD_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public int getAvailableProcessors() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.operatingSystemMBeanName, AVAILABLE_PROCESSORS);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Integer)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Integer)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getUptime() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.runtimeMBeanName, UP_TIME);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public int getLoadedClassCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.classLoadingMBeanName, LOADED_CLASS_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Integer)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Integer)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getTotalLoadedClassCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.classLoadingMBeanName, TOTAL_LOADED_CLASS_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getUnloadedClassCount() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.classLoadingMBeanName, UNLOADED_CLASS_COUNT);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getProcessCpuTime() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.operatingSystemMBeanName, PROCESS_CPU_TIME);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getTotalPhysicalMemorySize() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.operatingSystemMBeanName, TOTAL_PHYSICAL_MEMORY_SIZE);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getFreePhysicalMemorySize() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.operatingSystemMBeanName, FREE_PHYSICAL_MEMORY_SIZE);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }

    public long getCommittedVirtualMemorySize() throws PerformActionErrorException {
        try {
            Object result = this.getAttribute(this.operatingSystemMBeanName, COMMITTED_VIRTUAL_MEMORY_SIZE);
            if (result == null) {
                throw new PerformActionErrorException("Unexpected result : null");
            }
            if (!(result instanceof Long)) {
                throw new PerformActionErrorException("Unexpected result type");
            }
            return (Long)result;
        }
        catch (AttributeErrorException e) {
            throw new PerformActionErrorException(e);
        }
    }
}

