/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.jmx.RuntimeConfigurationComponentClient;

public class ConfigureRuntimeComponentTask
extends AbstractJBIAntTask {
    private static final Hashtable<String, Class<?>> primitiveClasses = new Hashtable(12);
    private String name;
    private List<Param> nestedParams = new ArrayList<Param>();
    private String params;

    public Param createParam() {
        Param param = new Param();
        this.nestedParams.add(param);
        return param;
    }

    @Override
    public void doTask() throws Exception {
        if (this.name == null) {
            throw new BuildException("Missing attribute 'name'");
        }
        Properties paramsProperties = this.loadProperties();
        RuntimeConfigurationComponentClient rccc = this.getJMXClient().getRuntimeConfigurationClient(this.name);
        this.log(this.nestedParams.size() + paramsProperties.size() + " runtime parameters will be set to the component '" + this.name + "'");
        if (rccc != null) {
            Map runtimeAttributes = rccc.getConfigurationMBeanAttributes();
            this.setRuntimeAttributes(runtimeAttributes, this.nestedParams, paramsProperties);
            rccc.setAttributes(runtimeAttributes);
            this.log("Runtime configuration of the component '" + this.name + "' set");
        } else {
            this.log("No runtime configuration MBean proposed by the runtime MBean!", LogLevel.WARN.getLevel());
        }
    }

    public List<Param> getNestedParams() {
        return this.nestedParams;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNestedParams(List<Param> nestedParams) {
        this.nestedParams = nestedParams;
    }

    public void setParams(String params) {
        this.params = params;
    }

    private Param containParam(List<Param> nestedParams, String name) {
        for (Param p : nestedParams) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    private Param containParam(Properties props, String name) {
        for (Object key : props.keySet()) {
            if (!name.equals((String)key)) continue;
            return new Param((String)key, (String)props.get(key));
        }
        return null;
    }

    private Properties loadProperties() throws IOException {
        Properties props = new Properties();
        if (this.params != null) {
            props.load(new FileInputStream(this.params));
        }
        return props;
    }

    private void setRuntimeAttributes(Map<MBeanAttributeInfo, Object> attrs, List<Param> nestedParam, Properties propertiesParam) {
        Set<Map.Entry<MBeanAttributeInfo, Object>> entriesSet = attrs.entrySet();
        for (Map.Entry<MBeanAttributeInfo, Object> entry : entriesSet) {
            Param param = this.containParam(this.nestedParams, entry.getKey().getName());
            if (param == null) {
                param = this.containParam(propertiesParam, entry.getKey().getName());
                if (param != null) {
                    this.log("Setting attribute from properties " + param.getName() + " = " + param.getValue());
                }
            } else {
                this.log("Setting attribute " + param.getName() + " = " + param.getValue());
            }
            if (param == null) continue;
            Object castedValue = null;
            if (primitiveClasses.containsKey(entry.getKey().getType())) {
                try {
                    Class<?> primitiveClass = primitiveClasses.get(entry.getKey().getType());
                    Method valueOfMethod = primitiveClass.getMethod("valueOf", String.class);
                    castedValue = valueOfMethod.invoke(null, param.getValue());
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else if (entry.getKey().getType().equals(String.class.getName())) {
                castedValue = param.getValue();
            }
            if (castedValue == null) {
                throw new RuntimeException("Failed to identify primitive type '" + entry.getKey().getType() + "' of parameter '" + entry.getKey().getName() + "'");
            }
            entry.setValue(castedValue);
        }
    }

    static {
        primitiveClasses.put(Boolean.class.getName(), Boolean.class);
        primitiveClasses.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveClasses.put(Short.class.getName(), Short.class);
        primitiveClasses.put(Short.TYPE.getName(), Short.class);
        primitiveClasses.put(Integer.class.getName(), Integer.class);
        primitiveClasses.put(Integer.TYPE.getName(), Integer.class);
        primitiveClasses.put(Long.class.getName(), Long.class);
        primitiveClasses.put(Long.TYPE.getName(), Long.class);
        primitiveClasses.put(Float.class.getName(), Float.class);
        primitiveClasses.put(Float.TYPE.getName(), Float.class);
        primitiveClasses.put(Double.class.getName(), Double.class);
        primitiveClasses.put(Double.TYPE.getName(), Double.class);
    }

    public static class Param {
        private String name;
        private String value;

        public Param() {
            this("", "");
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

