/****************************************************************************
 *
 * Copyright (c) 2005-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.ant.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : petals-force-undeploy-service-assembly. 
 * <p>
 * This task forces the undeployment of a previously deployed service assembly from the JBI
 * environment.
 * </p>
 * 
 * @author Roland Naudin - EBM WebSourcing
 */
public class ForceUndeployServiceAssemblyTask extends AbstractJBIAntTask {

    /**
     * Name of the JBI Service Assembly
     */
    private String name;

    @Override
    public void doTask() throws Exception {
        if (this.name == null) {
            throw new BuildException("Missing attribute 'name'");
        }

        boolean result = this.getJMXClient().getDeploymentServiceClient().forceUndeploy(this.name);

        // TODO : use a common library to handle properly the SA deployment
        // reports
        if (result) {
            log("Service assembly '" + name + "' forcibly undeployed");

        } else {
            log("Failed to force the undeployment of the Service Assembly '" + this.name + "'",
                    LogLevel.ERR.getLevel());
        }
    }

    /**
     * Set the name parameter
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

}
