/****************************************************************************
 *
 * Copyright (c) 2005-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.ant.task;

import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : petals-force-uninstall-component. 
 * <p>
 * This task forces the uninstallation of a previously installed JBI component (service engine or
 * binding) from the JBI environment.
 * </p>
 * 
 * @author Roland Naudin - EBM WebSourcing
 */
public class ForceUnloadInstallerTask extends AbstractJBIAntTask {

    /**
     * Name of the JBI component
     */
    private String name;

    @Override
    public void doTask() throws Exception {
        boolean result = this.getJMXClient().getInstallationServiceClient().forceUnloadInstaller(
                name);

        if (result) {
            log("Component '" + name + "' forcibly uninstalled and installer forcibly unloaded");
        } else {
            log("Failed to force the unload of installer of component '" + name + "'");
        }

    }

    /**
     * Set the name parameter
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

}
