/****************************************************************************
 *
 * Copyright (c) 2005-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.ant.task;

import java.io.IOException;
import java.net.URL;

import org.ow2.petals.ant.AbstractInstallerAntTask;

/**
 * Ant task : jbi-install-shared-library. 
 * <p>
 * This task install a shared library into the JBI environment.
 * </p>
 * 
 * @author ddesjardins - EBM WebSourcing
 * @author Christophe Hamerling - EBM WebSourcing
 */
public class InstallSharedLibraryTask extends AbstractInstallerAntTask {

    /**
     * Creates a new instance of {@link InstallSharedLibraryTask}
     * 
     */
    public InstallSharedLibraryTask() {
        super();
    }

    /**
     * Execute the ant task
     * 
     * @throws IOException
     */
    public void doTask() throws Exception {
        URL fileURL = this.validateFileParameter();

        String sharedLibrary = this.getJMXClient().getInstallationServiceClient()
                .installSharedLibrary(fileURL);
        
        log("Shared Library '" + sharedLibrary + "' installed");
    }
}
