/****************************************************************************
 *
 * Copyright (c) 2007-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.ant.task;

import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : jbi-undeploy-all-sa. 
 * <p>
 * This task undeploys all service assemblies.
 * If the boolean "force" is set to true, sa can be uninstalled in all states
 * </p>
 * 
 * @author Olivier Fabre - EBM WebSourcing
 */
public class UndeployAllServiceAssembliesTask extends AbstractJBIAntTask {

    /**
     * Boolean specifying if installer unloading must be executed in any state
     */
    private boolean force = false;

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.ant.AbstractJBIAntTask#doTask()
     */
    @Override
    public void doTask() throws Exception {
        String[] saNames = this.getJMXClient().getDeploymentServiceClient()
                .undeployAllServiceAssemblies(force);

        for (String saName : saNames) {
            log("Service Assembly '" + saName + "' undeployed");
        }
    }

    /**
     * set the force parameter
     * 
     * @param force
     */
    public void setForce(boolean force) {
        this.force = force;
    }
}
