/****************************************************************************
 *
 * Copyright (c) 2005-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.ant.task;

import org.ow2.petals.ant.AbstractJBIAntTask;

/**
 * Ant task : jbi-uninstall-all-comp. 
 * <p>This task uninstall all components.</p>
 * 
 * @author Olivier Fabre - EBM WebSourcing
 */
public class UninstallComponentsTask extends AbstractJBIAntTask {

    @Override
    public void doTask() throws Exception {
        String[] componentNames = this.getJMXClient().getInstallationServiceClient()
                .uninstallAllComponents();

        for (String componentName : componentNames) {
            log("Component '" + componentName + "' uninstalled");
        }
    }
}
