/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.ant.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;

/**
 * @author Roland Naudin - EBM WebSourcing
 */
public class NioUtil {
    
    /**
     * Size of buffer in bytes used during some operations.
     */
    private static final int BUFFER_SIZE = 4096;
    
    /**
     * Transfer bytes blocks using direct buffer memory allocation. Relies in
     * use the faster Java New I/O instead of traditional byte array move.
     * 
     * @param is
     *            the {@link InputStream} to copy
     * @param aFile
     *            the output {@link File}
     * @throws IOException
     *             if errors occured
     */
    public static final void copyStreamToFile(InputStream is, File aFile) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(is);
        FileOutputStream fos = new FileOutputStream(aFile);
        FileChannel outputChannel = fos.getChannel();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(BUFFER_SIZE);
            int readBytes;
            while ((readBytes = inputChannel.read(buffer)) != -1) {
                if (readBytes > 0) {
                    buffer.flip();
                    outputChannel.write(buffer);
                    buffer.clear();
                }
            }
        } finally {
            inputChannel.close();
            outputChannel.close();
            fos.close();
        }
    }

}
