/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import org.ow2.petals.jmx.exception.AttributeErrorException;
import org.ow2.petals.jmx.exception.PerformActionDoesNotExistException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public abstract class AbstractServiceClient {
    protected static final String JMX_FIELD_TYPE = "type";
    protected static final String JMX_FIELD_NAME = "name";
    protected static final String JMX_SERVICE_TYPE = "service";
    protected String petalsDomain = null;
    protected ObjectName mbeanName = null;
    protected MBeanServerConnection mBeanServerConnection = null;

    public AbstractServiceClient(String petalsDomain, MBeanServerConnection mBeanServerConnection) {
        this.petalsDomain = petalsDomain;
        this.mBeanServerConnection = mBeanServerConnection;
    }

    protected Object performAction(String action, Object[] objectsLoad, String[] stringsLoad) throws PerformActionErrorException {
        try {
            return this.mBeanServerConnection.invoke(this.mbeanName, action, objectsLoad, stringsLoad);
        }
        catch (MBeanException e) {
            if (e.getCause() instanceof ServiceNotFoundException) {
                throw new PerformActionDoesNotExistException(action, this.mbeanName, e);
            }
            throw new PerformActionErrorException(e.getCause());
        }
        catch (Exception e) {
            throw new PerformActionErrorException(e);
        }
    }

    protected Object getAttribute(String attributeName) throws AttributeErrorException {
        try {
            return this.mBeanServerConnection.getAttribute(this.mbeanName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (MBeanException e) {
            throw new AttributeErrorException(e);
        }
        catch (ReflectionException e) {
            throw new AttributeErrorException(e);
        }
        catch (IOException e) {
            throw new AttributeErrorException(e);
        }
    }

    protected Object getAttribute(ObjectName mbeanName, String attributeName) throws AttributeErrorException {
        try {
            return this.mBeanServerConnection.getAttribute(mbeanName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new AttributeErrorException(e);
        }
        catch (MBeanException e) {
            throw new AttributeErrorException(e);
        }
        catch (ReflectionException e) {
            throw new AttributeErrorException(e);
        }
        catch (IOException e) {
            throw new AttributeErrorException(e);
        }
    }
}

