/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.ComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public final class ComponentClient
extends AbstractServiceClient {
    protected static final String SHUTDOWN = "shutDown";
    protected static final String START = "start";
    protected static final String STOP = "stop";
    protected static final String GET_CURRENT_STATE = "getCurrentState";

    public ComponentClient(String petalsDomain, String componentName, MBeanServerConnection mBeanServerConnection) throws ComponentDoesNotExistException, ComponentErrorException {
        block5: {
            super(petalsDomain, mBeanServerConnection);
            try {
                String pattern = "*:type=engine,name=" + componentName;
                ObjectName objName = new ObjectName(pattern);
                Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
                if (objNames != null && objNames.size() == 1) {
                    this.mbeanName = objNames.iterator().next();
                    break block5;
                }
                pattern = "*:type=binding,name=" + componentName;
                objName = new ObjectName(pattern);
                objNames = this.mBeanServerConnection.queryNames(objName, null);
                if (objNames != null && objNames.size() == 1) {
                    this.mbeanName = objNames.iterator().next();
                    break block5;
                }
                throw new ComponentDoesNotExistException(componentName);
            }
            catch (MalformedObjectNameException e) {
                throw new ComponentErrorException(e);
            }
            catch (IOException e) {
                throw new ComponentErrorException(e);
            }
        }
    }

    public ComponentClient(ObjectName componentObjectName, MBeanServerConnection mBeanServerConnection) throws ComponentDoesNotExistException, ComponentErrorException {
        super(componentObjectName.getDomain(), mBeanServerConnection);
        this.mbeanName = componentObjectName;
    }

    public void start() throws ComponentErrorException {
        try {
            this.performAction(START, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new ComponentErrorException(e);
        }
    }

    public void stop() throws ComponentErrorException {
        try {
            this.performAction(STOP, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new ComponentErrorException(e);
        }
    }

    public void shutdown() throws ComponentErrorException {
        try {
            this.performAction(SHUTDOWN, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new ComponentErrorException(e);
        }
    }

    public String getState() throws ComponentErrorException {
        String state;
        try {
            state = (String)this.performAction(GET_CURRENT_STATE, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new ComponentErrorException(e);
        }
        catch (ClassCastException e) {
            throw new ComponentErrorException("Unexpected result type");
        }
        return state;
    }

    public static final class State {
        public static final String STARTED = "Started";
        public static final String STOPPED = "Stopped";
        public static final String SHUTDOWN = "Shutdown";
    }
}

