/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.exception.DeploymentServiceDoesNotExistException;
import org.ow2.petals.jmx.exception.DeploymentServiceErrorException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public final class DeploymentServiceClient
extends AbstractServiceClient {
    private static final String DEPLOY = "deploy";
    private static final String DEPLOYMENT_SERVICE_JMX_NAME = "Deployment";
    private static final String FORCE_UNDEPLOY = "forceUndeploy";
    private static final String GET_DEPLOYED_SAS = "getDeployedServiceAssemblies";
    private static final String GET_DEPLOYED_SAS_FOR_COMPONENT = "getDeployedServiceAssembliesForComponent";
    private static final String GET_SERVICE_ASSEMBLY_DESCRIPTOR = "getServiceAssemblyDescriptor";
    private static final String GET_SERVICE_UNIT_FOR_SA = "getServiceUnitForServiceAssembly";
    private static final String GET_STATE = "getState";
    private static final String SHUTDOWN = "shutDown";
    private static final String SHUTDOWN_ALL_SAS = "shutdownAllServiceAssemblies";
    private static final String START = "start";
    private static final String START_ALL_SAS = "startAllServiceAssemblies";
    private static final String STOP = "stop";
    private static final String STOP_ALL_SAS = "stopAllServiceAssemblies";
    private static final String UNDEPLOY = "undeploy";
    private static final String UNDEPLOY_ALL_SAS = "undeployAllServiceAssemblies";

    public DeploymentServiceClient(String petalsDomain, MBeanServerConnection mBeanServerConnection) throws DeploymentServiceDoesNotExistException, DeploymentServiceErrorException {
        super(petalsDomain, mBeanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", DEPLOYMENT_SERVICE_JMX_NAME);
            attributes.put("type", "service");
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new DeploymentServiceDoesNotExistException();
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (IOException e) {
            throw new DeploymentServiceErrorException(e);
        }
    }

    public String deploy(URL packageURL) throws DeploymentServiceErrorException {
        String result;
        Object[] objects = new Object[]{packageURL.toString()};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (String)this.performAction(DEPLOY, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public Boolean forceUndeploy(String serviceAssemblyName) throws DeploymentServiceErrorException {
        Boolean result;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (Boolean)this.performAction(FORCE_UNDEPLOY, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] getDeployedServiceAssemblies() throws DeploymentServiceErrorException {
        String[] sas;
        try {
            sas = (String[])this.performAction(GET_DEPLOYED_SAS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return sas;
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) throws DeploymentServiceErrorException {
        String[] sas;
        Object[] objects = new Object[]{componentName};
        String[] strings = new String[]{String.class.getName()};
        try {
            sas = (String[])this.performAction(GET_DEPLOYED_SAS_FOR_COMPONENT, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return sas;
    }

    public String getServiceAssemblyDescriptor(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String saDescriptor;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            saDescriptor = (String)this.performAction(GET_SERVICE_ASSEMBLY_DESCRIPTOR, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return saDescriptor;
    }

    public String[] getServiceUnitForServiceAssembly(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String[] suNames;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            suNames = (String[])this.performAction(GET_SERVICE_UNIT_FOR_SA, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return suNames;
    }

    public String getState(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String result;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (String)this.performAction(GET_STATE, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public boolean isServiceAssemblyDeployed(String serviceAssembly) throws DeploymentServiceErrorException {
        String[] deployedSAs;
        boolean result = false;
        for (String deployedSA : deployedSAs = this.getDeployedServiceAssemblies()) {
            if (!deployedSA.equals(serviceAssembly)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String shutdown(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String result;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (String)this.performAction(SHUTDOWN, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] shutdownAllServiceAssemblies() throws DeploymentServiceErrorException {
        String[] saNames;
        try {
            saNames = (String[])this.performAction(SHUTDOWN_ALL_SAS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return saNames;
    }

    public String start(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String result;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (String)this.performAction(START, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] startAllServiceAssemblies() throws DeploymentServiceErrorException {
        String[] saNames;
        try {
            saNames = (String[])this.performAction(START_ALL_SAS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return saNames;
    }

    public String stop(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String result;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (String)this.performAction(STOP, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] stopAllServiceAssemblies() throws DeploymentServiceErrorException {
        String[] saNames;
        try {
            saNames = (String[])this.performAction(STOP_ALL_SAS, null, null);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return saNames;
    }

    public String undeploy(String serviceAssemblyName) throws DeploymentServiceErrorException {
        String result;
        Object[] objects = new Object[]{serviceAssemblyName};
        String[] strings = new String[]{String.class.getName()};
        try {
            result = (String)this.performAction(UNDEPLOY, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return result;
    }

    public String[] undeployAllServiceAssemblies(boolean force) throws DeploymentServiceErrorException {
        String[] saNames;
        Object[] objects = new Object[]{force};
        String[] strings = new String[]{Boolean.TYPE.getName()};
        try {
            saNames = (String[])this.performAction(UNDEPLOY_ALL_SAS, objects, strings);
        }
        catch (PerformActionErrorException e) {
            throw new DeploymentServiceErrorException(e);
        }
        catch (ClassCastException e) {
            throw new DeploymentServiceErrorException("Unexpected result type");
        }
        return saNames;
    }

    public static final class State {
        public static final String SHUTDOWN = "Shutdown";
        public static final String STARTED = "Started";
        public static final String STOPPED = "Stopped";
    }
}

