/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.util.ArrayList;
import org.ow2.petals.ant.AbstractJBIAntTask;

public class ListSharedLibrariesTask
extends AbstractJBIAntTask {
    private static final String XMLNS = "http://java.sun.com/xml/ns/jbi/component-info-list";
    private String componentName;
    private String sharedLibraryName;
    private String xmlOutput;

    @Override
    public void doTask() throws Exception {
        String[] sharedLibraryNames = this.getJMXClient().getInstallationServiceClient().getInstalledSharedLibraries();
        ArrayList<String> sharedLibraryList = new ArrayList<String>();
        for (String slName : sharedLibraryNames) {
            if (this.componentName != null) {
                String[] componentNames = this.getJMXClient().getInstallationServiceClient().getInstalledComponentsForSharedlibrary(slName);
                boolean found = false;
                for (String compName : componentNames) {
                    if (!this.componentName.equals(compName)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (this.sharedLibraryName != null && !this.sharedLibraryName.equals(slName)) continue;
            sharedLibraryList.add(slName);
        }
        StringBuffer output = new StringBuffer();
        StringBuffer outputXML = new StringBuffer();
        output.append("#######################################################\n");
        output.append("#                    Shared Libraries                 #\n");
        output.append("#######################################################\n");
        outputXML.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        outputXML.append("<component-info-list ");
        outputXML.append("xmlns='http://java.sun.com/xml/ns/jbi/component-info-list' version='1.0'>\n");
        for (String name : sharedLibraryList) {
            String state = "TODO";
            String description = "TODO";
            output.append("Name        : " + name + "\n");
            output.append("State       : " + state + "\n");
            output.append("Description : " + description + "\n\n");
            outputXML.append("\t<component-info type='shared-library' name='");
            outputXML.append(name);
            outputXML.append("' state='");
            outputXML.append(state);
            outputXML.append("'>\n\t\t<description>");
            outputXML.append(description);
            outputXML.append("</description>\n");
            outputXML.append("\t</component-info>");
        }
        outputXML.append("</component-info-list>");
        if (this.xmlOutput == null) {
            this.log(output.toString());
        } else {
            this.getProject().setNewProperty(this.xmlOutput, outputXML.toString());
        }
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setSharedLibraryName(String sharedLibraryName) {
        this.sharedLibraryName = sharedLibraryName;
    }

    public void setXmlOutput(String xmlOutput) {
        this.xmlOutput = xmlOutput;
    }
}

