/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import org.apache.tools.ant.BuildException;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.ant.AbstractConfigureArchiveAntTask;

public class AbstractConfigureArchiveAntTaskTest {
    @Test
    public void testValidateFileParameter_Null() {
        TestConfigureTask tct = new TestConfigureTask();
        try {
            tct.validateParam(null, "file");
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Missing attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Empty() {
        TestConfigureTask tct = new TestConfigureTask();
        try {
            tct.validateParam("", "file");
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Empty attribute 'file'"));
        }
    }

    @Test
    public void testValidateFileParameter_Invalid() {
        String invalidFile = "/tmp/foo";
        TestConfigureTask tct = new TestConfigureTask();
        try {
            tct.validateParam("/tmp/foo", "file");
            Assert.fail((String)("The exception '" + BuildException.class.getName() + "' is not thrown."));
        }
        catch (BuildException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("/tmp/foo"));
            Assert.assertTrue((boolean)e.getMessage().contains("is not a valid archive (zip or jar required)"));
        }
    }

    @Test
    public void testValidateFileParameter_JAR() throws BuildException {
        TestConfigureTask tct = new TestConfigureTask();
        tct.validateParam("/tmp/foo.jar", "file");
    }

    @Test
    public void testValidateFileParameter_ZIP() throws BuildException {
        TestConfigureTask tct = new TestConfigureTask();
        tct.validateParam("/tmp/foo.zip", "file");
    }

    private class TestConfigureTask
    extends AbstractConfigureArchiveAntTask {
        private TestConfigureTask() {
        }

        public final void validateParam(String fileParameter, String paramaterName) throws BuildException {
            AbstractConfigureArchiveAntTask.validateFileParameter((String)fileParameter, (String)paramaterName);
        }
    }
}

