/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.petals.ant.util.NioUtil;

public class AbstractConfigureArchiveAntTask
extends Task {
    protected static final String JBIDESCRIPTOR_ZIPENTRY_NAME = "META-INF/jbi.xml";
    protected String file;
    protected String outputFile;
    protected boolean overwriteOutputFile = true;

    public void execute() throws BuildException {
        super.execute();
        URL outputFileURL = AbstractConfigureArchiveAntTask.validateFileParameter(this.outputFile, "outputFile");
        try {
            File outputFileFile = new File(outputFileURL.toURI());
            if (!this.overwriteOutputFile && outputFileFile.exists()) {
                throw new BuildException("The output component archive '" + this.outputFile + "' already exists.");
            }
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final File downloadURL(URL componentURL) throws IOException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File outputFile = null;
        try {
            String path = componentURL.getPath();
            String fileName = path.substring(path.lastIndexOf(47) + 1);
            outputFile = File.createTempFile(fileName, null);
            inputStream = componentURL.openStream();
            NioUtil.copyStreamToFile(inputStream, outputFile);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return outputFile;
    }

    protected static final URL validateFileParameter(String fileParameter, String paramaterName) throws BuildException {
        URL fileURL;
        if (fileParameter == null) {
            throw new BuildException("Missing attribute '" + paramaterName + "'");
        }
        if (fileParameter.isEmpty()) {
            throw new BuildException("Empty attribute '" + paramaterName + "'");
        }
        if (!fileParameter.endsWith(".zip") && !fileParameter.endsWith(".jar")) {
            throw new BuildException("File '" + fileParameter + "' is not a valid archive (zip or jar required)");
        }
        try {
            fileURL = new URL(fileParameter);
        }
        catch (MalformedURLException e) {
            try {
                fileURL = new File(fileParameter).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                throw new BuildException("Wrong format for attribute '" + paramaterName + "', a valid file location is required");
            }
        }
        return fileURL;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public boolean isOverwriteOutputFile() {
        return this.overwriteOutputFile;
    }

    public void setOverwriteOutputFile(boolean overwriteOutputFile) {
        this.overwriteOutputFile = overwriteOutputFile;
    }
}

