/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.jbi.descriptor.original.JBIDescriptorBuilder;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;

public class ListServiceAssembliesTask
extends AbstractJBIAntTask {
    private static final String XMLNS = "http://java.sun.com/xml/ns/jbi/service-assembly-info-list";
    private String componentName;
    private String serviceAssemblyName;
    private String state;
    private String xmlOutput;

    @Override
    public void doTask() throws Exception {
        String[] serviceAssemblyNames;
        if (!(this.state == null || "Shutdown".equalsIgnoreCase(this.state) || "Started".equalsIgnoreCase(this.state) || "Stopped".equalsIgnoreCase(this.state))) {
            throw new BuildException("Valid states are : 'Shutdown', 'Started', or 'Stopped'");
        }
        if (this.componentName != null) {
            serviceAssemblyNames = this.getJMXClient().getDeploymentServiceClient().getDeployedServiceAssembliesForComponent(this.componentName);
        } else {
            String[] saNames;
            ArrayList<String> saList = new ArrayList<String>();
            for (String saName : saNames = this.getJMXClient().getDeploymentServiceClient().getDeployedServiceAssemblies()) {
                String currentState;
                if (this.serviceAssemblyName != null) {
                    if (!saName.equals(this.serviceAssemblyName)) continue;
                    saList.add(saName);
                    break;
                }
                if (this.state != null && this.state.equalsIgnoreCase(currentState = this.getJMXClient().getDeploymentServiceClient().getState(saName))) continue;
                saList.add(saName);
            }
            serviceAssemblyNames = saList.toArray(new String[0]);
        }
        StringBuffer output = new StringBuffer();
        StringBuffer outputXML = new StringBuffer();
        output.append("#######################################################\n");
        output.append("#                 Service Assemblies                  #\n");
        output.append("#######################################################\n");
        outputXML.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        outputXML.append("<service-assembly-info-list xmlns=\"").append(XMLNS).append("\" version=\"1.0\">\n");
        for (String saName : serviceAssemblyNames) {
            String[] sus;
            String descriptor = this.getJMXClient().getDeploymentServiceClient().getServiceAssemblyDescriptor(saName);
            ByteArrayInputStream bais = new ByteArrayInputStream(descriptor.getBytes());
            Jbi saJbiDescriptor = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)bais);
            bais.close();
            String saDescription = saJbiDescriptor.getServiceAssembly().getIdentification().getDescription();
            String saState = this.getJMXClient().getDeploymentServiceClient().getState(saName);
            output.append("Name : " + saName + "\n");
            output.append("State : " + saState + "\n");
            output.append("Description : " + saDescription + "\n\n");
            outputXML.append("\t<service-assembly-info name=\"").append(saName).append("\" state=\"").append(saState).append("\">\n");
            outputXML.append("\t\t<description>").append(saDescription).append("</description>\n");
            for (String suName : sus = this.getJMXClient().getDeploymentServiceClient().getServiceUnitForServiceAssembly(saName)) {
                String suDescription = "";
                String suComponentName = "";
                List suDescriptors = saJbiDescriptor.getServiceAssembly().getServiceUnit();
                for (ServiceUnit suDescriptor : suDescriptors) {
                    if (!suName.equals(suDescriptor.getIdentification().getName())) continue;
                    suDescription = suDescriptor.getIdentification().getDescription();
                    suComponentName = suDescriptor.getTarget().getComponentName();
                    break;
                }
                output.append("--------------------Service Unit-----------------------\n");
                output.append("Name : " + suName + "\n");
                output.append("State : " + saState + "\n");
                output.append("Description : " + suDescription + "\n\n");
                outputXML.append("\t\t<service-unit-info name=\"").append(suName).append("\" state=\"").append(saState).append("\" deployed-on=\"").append(suComponentName).append("\">\n");
                outputXML.append("\t\t\t<description>").append(suDescription).append("</description>\n");
                outputXML.append("\t\t</service-unit-info>\n");
            }
            outputXML.append("\t</service-assembly-info>\n");
        }
        outputXML.append("</service-assembly-info-list>");
        if (this.xmlOutput == null) {
            this.log(output.toString());
        } else {
            this.getProject().setNewProperty(this.xmlOutput, outputXML.toString());
        }
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setServiceAssemblyName(String serviceAssemblyName) {
        this.serviceAssemblyName = serviceAssemblyName;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setXmlOutput(String xmlOutput) {
        this.xmlOutput = xmlOutput;
    }
}

