/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons.log;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import javax.xml.namespace.QName;
import org.ow2.petals.commons.log.FlowAttributes;

public final class PetalsExecutionContext {
    public static final String CONTAINER_NAME_PROPERTY_NAME = "containerName";
    public static final String FLOW_INSTANCE_ID_PROPERTY_NAME = "flowInstanceId";
    public static final String FLOW_STEP_ID_PROPERTY_NAME = "flowStepId";
    public static final String FLOW_PREVIOUS_STEP_ID_PROPERTY_NAME = "flowPreviousStepId";
    public static final String FLOW_STEP_INTERFACE_NAME_PROPERTY_NAME = "flowStepInterfaceName";
    public static final String FLOW_STEP_OPERATION_NAME_PROPERTY_NAME = "flowStepOperationName";
    public static final String FLOW_STEP_SERVICE_NAME_PROPERTY_NAME = "flowStepServiceName";
    public static final String FLOW_STEP_ENDPOINT_NAME_PROPERTY_NAME = "flowStepEndpointName";
    public static final String FLOW_EXCHANGE_PROPERTY_NAME = "flowExchange";
    private static final SimpleUUIDGenerator simpleUUIDGenerator = new SimpleUUIDGenerator();

    public static final void putContainerName(String containerName) {
        assert (containerName != null);
        ExecutionContext.getProperties().setProperty(CONTAINER_NAME_PROPERTY_NAME, containerName);
    }

    public static final void putFlowInstanceId(String flowInstanceId) {
        assert (flowInstanceId != null);
        ExecutionContext.getProperties().setProperty(FLOW_INSTANCE_ID_PROPERTY_NAME, flowInstanceId);
    }

    public static final void initFlowInstanceId() {
        PetalsExecutionContext.putFlowInstanceId(simpleUUIDGenerator.getNewID());
    }

    public static final void putFlowStepId(String flowStepId) {
        assert (flowStepId != null);
        ExecutionContext.getProperties().setProperty(FLOW_STEP_ID_PROPERTY_NAME, flowStepId);
    }

    public static void nextFlowStepId() {
        if (ExecutionContext.getProperties().getProperty(FLOW_STEP_ID_PROPERTY_NAME) != null) {
            ExecutionContext.getProperties().setProperty(FLOW_PREVIOUS_STEP_ID_PROPERTY_NAME, ExecutionContext.getProperties().getProperty(FLOW_STEP_ID_PROPERTY_NAME));
        }
        ExecutionContext.getProperties().setProperty(FLOW_STEP_ID_PROPERTY_NAME, simpleUUIDGenerator.getNewID());
    }

    public static final void putFlowStepInterfaceName(QName interfaceName) {
        assert (interfaceName != null);
        ExecutionContext.getProperties().setProperty(FLOW_STEP_INTERFACE_NAME_PROPERTY_NAME, interfaceName.toString());
    }

    public static final void putFlowStepOperationName(QName operation) {
        assert (operation != null);
        ExecutionContext.getProperties().setProperty(FLOW_STEP_OPERATION_NAME_PROPERTY_NAME, operation.toString());
    }

    public static final void putFlowStepServiceName(QName serviceName) {
        assert (serviceName != null);
        ExecutionContext.getProperties().setProperty(FLOW_STEP_SERVICE_NAME_PROPERTY_NAME, serviceName.toString());
    }

    public static final void putFlowStepEndpointName(String flowStepEndpointName) {
        assert (flowStepEndpointName != null);
        ExecutionContext.getProperties().setProperty(FLOW_STEP_ENDPOINT_NAME_PROPERTY_NAME, flowStepEndpointName);
    }

    public static final void clear() {
        String containerName = ExecutionContext.getProperties().getProperty(CONTAINER_NAME_PROPERTY_NAME);
        ExecutionContext.getProperties().clear();
        if (containerName != null) {
            PetalsExecutionContext.putContainerName(containerName);
        }
    }

    public static final FlowAttributes getFlowAttributes() {
        String flowInstanceId = ExecutionContext.getProperties().getProperty(FLOW_INSTANCE_ID_PROPERTY_NAME);
        if (flowInstanceId == null) {
            return null;
        }
        String flowStepId = ExecutionContext.getProperties().getProperty(FLOW_STEP_ID_PROPERTY_NAME);
        if (flowStepId == null) {
            return null;
        }
        return new FlowAttributes(flowInstanceId, flowStepId);
    }

    public static final void putFlowAttributes(FlowAttributes flowAttributes) {
        assert (flowAttributes != null);
        PetalsExecutionContext.putFlowInstanceId(flowAttributes.getFlowInstanceId());
        PetalsExecutionContext.putFlowStepId(flowAttributes.getFlowStepId());
    }
}

