/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jmx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.petals.jmx.AbstractServiceClient;
import org.ow2.petals.jmx.ConfigurationInstallerComponentClient;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.InstallerComponentDoesNotExistException;
import org.ow2.petals.jmx.exception.PerformActionErrorException;

public final class InstallerComponentClient
extends AbstractServiceClient {
    protected static final String INIT = "init";
    protected static final String INSTALL = "install";
    protected static final String UNINSTALL = "uninstall";
    protected static final String IS_INSTALLED = "isInstalled";
    protected static final String GET_INSTALL_ROOT = "getInstallRoot";
    protected static final String GET_INSTALLER_CONFIGURATION_MBEAN = "getInstallerConfigurationMBean";
    private static final String INSTALLER_COMPONENT_JMX_TYPE = "installer";
    private ConfigurationInstallerComponentClient configurationInstaller = null;

    public InstallerComponentClient(String petalsDomain, String componentName, MBeanServerConnection mBeanServerConnection) throws InstallerComponentDoesNotExistException, ComponentErrorException {
        super(petalsDomain, mBeanServerConnection);
        try {
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("name", componentName);
            attributes.put("type", INSTALLER_COMPONENT_JMX_TYPE);
            ObjectName objName = new ObjectName(petalsDomain, attributes);
            Set<ObjectName> objNames = this.mBeanServerConnection.queryNames(objName, null);
            if (objNames == null || objNames.size() != 1) {
                throw new InstallerComponentDoesNotExistException(componentName);
            }
            this.mbeanName = objNames.iterator().next();
        }
        catch (MalformedObjectNameException e) {
            throw new ComponentErrorException(e);
        }
        catch (IOException e) {
            throw new ComponentErrorException(e);
        }
    }

    public InstallerComponentClient(String petalsDomain, ObjectName objectName, MBeanServerConnection mBeanServerConnection) {
        super(petalsDomain, mBeanServerConnection);
        this.mbeanName = objectName;
    }

    public void install() throws PerformActionErrorException {
        this.performAction(INSTALL, null, null);
    }

    public void uninstall() throws PerformActionErrorException {
        this.performAction(UNINSTALL, null, null);
    }

    public boolean isInstalled() throws PerformActionErrorException {
        Boolean result;
        try {
            result = (Boolean)this.performAction(IS_INSTALLED, null, null);
        }
        catch (ClassCastException e) {
            throw new PerformActionErrorException("Unexpected result type");
        }
        return result;
    }

    public String getInstallRoot() throws PerformActionErrorException {
        String result;
        try {
            result = (String)this.performAction(GET_INSTALL_ROOT, null, null);
        }
        catch (ClassCastException e) {
            throw new PerformActionErrorException("Unexpected result type");
        }
        return result;
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    public ConfigurationInstallerComponentClient getConfigurationInstallerClient() throws PerformActionErrorException {
        if (this.configurationInstaller == null) {
            ObjectName result = null;
            MBeanInfo mbeanInfo = null;
            try {
                result = (ObjectName)this.performAction(GET_INSTALLER_CONFIGURATION_MBEAN, null, null);
                mbeanInfo = this.mBeanServerConnection.getMBeanInfo(result);
            }
            catch (InstanceNotFoundException e) {
                throw new PerformActionErrorException(e);
            }
            catch (IntrospectionException e) {
                throw new PerformActionErrorException(e);
            }
            catch (ReflectionException e) {
                throw new PerformActionErrorException(e);
            }
            catch (IOException e) {
                throw new PerformActionErrorException(e);
            }
            this.configurationInstaller = new ConfigurationInstallerComponentClient(result, this.petalsDomain, this.mBeanServerConnection, mbeanInfo);
        }
        return this.configurationInstaller;
    }
}

