/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.jbi.messaging.MessagingException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class FileTransferUtilsTest {
    @Test
    public void testCreateMessageOnBaseMsgWithAttachementMode() {
        String transferMode = "attachment";
        String baseMsg = "<tes:executeJobOnly xmlns:tes=\"http://petals.ow2.org/talend/TestAttachPetals/\">        <tes:contexts>            <tes:outputLocation>C:/Documents and Settings/vzurczak/Bureau/de/out.xml</tes:outputLocation>         </tes:contexts>         <tes:in-attachments>            <tes:inputLocation>               <tes:fileContent>$attachment</tes:fileContent>            </tes:inputLocation>         </tes:in-attachments>      </tes:executeJobOnly>";
        try {
            File processedFile = File.createTempFile("test-file", "properties");
            processedFile.deleteOnExit();
            String fileName = processedFile.getName();
            Document doc = FileTransferUtils.createMessageOnBaseMsg((File)processedFile, (String)fileName, (String)baseMsg, (String)transferMode);
            NodeList tesLst = doc.getElementsByTagNameNS("http://petals.ow2.org/talend/TestAttachPetals/", "*");
            Assert.assertTrue((String)"Test if is namespace aware : Retrieve all element with the default namespace", (tesLst.getLength() != 0 ? 1 : 0) != 0);
            NodeList xopLst = doc.getElementsByTagNameNS("http://www.w3.org/2004/08/xop/include", "*");
            Assert.assertTrue((String)"Test if is namespace aware : Retrieved the added xop:Include element", (xopLst.getLength() != 0 ? 1 : 0) != 0);
        }
        catch (MessagingException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateMessageOnBaseMsgWithContentMode() {
        FileOutputStream fos = null;
        String transferMode = "content";
        String xmlContent = "<testns:elt1 xmlns:testns=\"http://petals.ow2.org/testNS/\">tutu</testns:elt1>";
        String baseMsg = "<tes:executeJobOnly xmlns:tes=\"http://petals.ow2.org/talend/TestAttachPetals/\">        <tes:contexts>            <tes:outputLocation>C:/Documents and Settings/vzurczak/Bureau/de/out.xml</tes:outputLocation>         </tes:contexts>         <tes:in-attachments>            <tes:inputLocation>               <tes:fileContent>$content</tes:fileContent>            </tes:inputLocation>         </tes:in-attachments>      </tes:executeJobOnly>";
        try {
            File processedFile = File.createTempFile("test-file", "properties");
            processedFile.deleteOnExit();
            fos = new FileOutputStream(processedFile);
            String fileName = processedFile.getName();
            fos.write(xmlContent.getBytes());
            Document doc = FileTransferUtils.createMessageOnBaseMsg((File)processedFile, (String)fileName, (String)baseMsg, (String)transferMode);
            NodeList tesLst = doc.getElementsByTagNameNS("http://petals.ow2.org/talend/TestAttachPetals/", "*");
            Assert.assertTrue((String)"Test if is namespace aware : Retrieve all element with the default namespace", (tesLst.getLength() != 0 ? 1 : 0) != 0);
            NodeList includeDocLst = doc.getElementsByTagNameNS("http://petals.ow2.org/testNS/", "*");
            Assert.assertTrue((String)"Test if is namespace aware : Retrieved the added element", (includeDocLst.getLength() != 0 ? 1 : 0) != 0);
        }
        catch (MessagingException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    @Test
    @Ignore
    public void testCreateMessageOnDefaultMsg() {
    }
}

