/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.util;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransferReport {
    private Map<File, Exception> transferedFiles = new HashMap<File, Exception>();
    public static final String NAMESPACE = "http://petals.ow2.org/component/filetransfer/report";
    public static final String ROOT_ELEMENT = "transferReport";
    public static final String FILE_ELEMENT = "file";
    public static final String FILENAME_ATTRIBUTE = "name";
    public static final String TRANSFER_ATTRIBUTE = "transfer";
    public static final String FILENAME_OK = "OK";
    public static final String FILENAME_KO = "KO";
    public static final String EXCEPTION_ELEMENT = "Exception";
    private boolean failedTransfer = false;

    public void addTransferedFile(File file, Exception exception) {
        if (file == null) {
            throw new IllegalArgumentException("The file parameter must be non null");
        }
        if (exception != null) {
            this.failedTransfer = true;
        }
        this.transferedFiles.put(file, exception);
    }

    public String generateRawReport() {
        StringBuilder report = new StringBuilder();
        for (File transferedFile : this.transferedFiles.keySet()) {
            report.append("File: ").append(transferedFile.getAbsolutePath()).append(" - transfer status: ");
            if (this.transferedFiles.get(transferedFile) == null) {
                report.append(FILENAME_OK);
            } else {
                report.append(FILENAME_KO).append(". Cause: " + this.transferedFiles.get(transferedFile).getMessage());
            }
            report.append(".\n");
        }
        return report.toString();
    }

    public Document generateXmlReport() {
        Document reportDocument = DocumentBuilders.newDocument();
        Element root = reportDocument.createElementNS(NAMESPACE, ROOT_ELEMENT);
        reportDocument.appendChild(root);
        for (File transferedFile : this.transferedFiles.keySet()) {
            Element fileTransfered = reportDocument.createElement(FILE_ELEMENT);
            root.appendChild(fileTransfered);
            fileTransfered.setAttribute(FILENAME_ATTRIBUTE, transferedFile.getAbsolutePath());
            if (this.transferedFiles.get(transferedFile) == null) {
                fileTransfered.setAttribute(TRANSFER_ATTRIBUTE, FILENAME_OK);
                continue;
            }
            fileTransfered.setAttribute(TRANSFER_ATTRIBUTE, FILENAME_KO);
            Element exception = reportDocument.createElement(EXCEPTION_ELEMENT);
            exception.setTextContent(this.transferedFiles.get(transferedFile).getMessage());
            fileTransfered.appendChild(exception);
        }
        return reportDocument;
    }

    public boolean containsFailedTransfer() {
        return this.failedTransfer;
    }
}

