/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DelFileService
extends AbstractFileService {
    public DelFileService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("del", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node filePatternNode = XMLHelper.findChild((Node)inMessageDoc.getDocumentElement(), null, (String)"filename", (boolean)true);
        if (filePatternNode == null) {
            throw new MessagingException("Missing element : filename");
        }
        String filePattern = filePatternNode.getTextContent();
        if (filePattern == null) {
            throw new MessagingException("null value for parameter filename");
        }
        try {
            File readDirectory = FileTransferUtils.getFolderPath(this.extensions);
            this.addMonitBeginStepExtTrace(filePattern, readDirectory.getName());
            boolean isDeleted = this.del(readDirectory, filePattern);
            if (!isDeleted) {
                throw new IOException("delete command fail");
            }
        }
        catch (IOException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not delete file [");
            errorSB.append(filePattern);
            errorSB.append("] : IOException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
    }

    private boolean del(File readDirectory, String filePattern) throws IOException {
        File[] files = FileTransferUtils.listFiles(readDirectory, filePattern);
        boolean isDeleted = false;
        if (files.length <= 0) {
            throw new IOException("file : '" + filePattern + "' not found");
        }
        isDeleted = files[0].delete();
        return isDeleted;
    }
}

