/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.bc.filetransfer.FiletransferProvideExtFlowStepBeginLogData;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.logger.ProvideExtFlowStepEndLogData;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Document;

public abstract class AbstractFileService {
    protected Logger logger;
    protected ConfigurationExtensions extensions;

    public AbstractFileService(ConfigurationExtensions extensions, Logger logger) {
        this.extensions = extensions;
        this.logger = logger;
    }

    public abstract void process(Exchange var1, Document var2) throws MessagingException;

    public String getTargetFileName(Exchange exchange) {
        String fileName = this.extensions.get((Object)"filename");
        if (StringHelper.isNullOrEmpty((String)fileName)) {
            fileName = exchange.getOperation() != null ? exchange.getOperationName() + ".xml" : "content.xml";
        }
        fileName = FileTransferUtils.addDateToFileName(fileName);
        return fileName;
    }

    protected void addMonitEndStepExtTrace() {
        FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
        String flowInstanceId = "";
        String flowStepId = "";
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        this.logger.log(Level.MONIT, "", new ProvideExtFlowStepEndLogData(flowInstanceId, flowStepId));
    }

    protected void addMonitBeginStepExtTrace(String filePattern, String destDirName) {
        FlowAttributes flowAttributes = PetalsExecutionContext.getFlowAttributes();
        String flowInstanceId = "";
        String flowStepId = "";
        if (flowAttributes != null) {
            flowInstanceId = flowAttributes.getFlowInstanceId();
            flowStepId = flowAttributes.getFlowStepId();
        }
        FiletransferProvideExtFlowStepBeginLogData flowLogData = new FiletransferProvideExtFlowStepBeginLogData(flowInstanceId, flowStepId, filePattern, destDirName);
        this.logger.log(Level.MONIT, "", (Object)flowLogData);
    }
}

