/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.bc.filetransfer.util.TransferReport;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.w3c.dom.Document;

public class MPutFileService
extends AbstractFileService {
    public MPutFileService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        File directory;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MPUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("mput", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        if (exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("One or more attachments expected.");
            throw new MessagingException(errorSB.toString());
        }
        TransferReport transferReport = new TransferReport();
        Map attachments = MtomUtil.getAttachments((Document)inMessageDoc, (NormalizedMessage)exchange.getInMessage());
        try {
            directory = FileTransferUtils.getFolderPath(this.extensions);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage());
        }
        StringBuilder builder = new StringBuilder();
        Iterator it = attachments.keySet().iterator();
        while (it.hasNext()) {
            builder.append("(" + (String)it.next() + ")");
            if (!it.hasNext()) continue;
            builder.append("|");
        }
        this.addMonitBeginStepExtTrace(builder.toString(), directory.getName());
        for (String name : attachments.keySet()) {
            DataHandler dataHandler = exchange.getInMessageAttachment(name);
            this.copyAttachment(dataHandler, name, directory, transferReport);
        }
        if (transferReport != null && transferReport.containsFailedTransfer()) {
            String report = transferReport.generateRawReport();
            this.logger.log(Level.WARNING, report);
            throw new MessagingException(report);
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MPUT operation ended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAttachment(DataHandler attachment, String name, File directory, TransferReport transferReport) {
        File target = new File(directory, name);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(target);
            this.logger.info("Attachment transfer to file : " + target.getAbsolutePath());
            attachment.writeTo((OutputStream)os);
            transferReport.addTransferedFile(target, null);
        }
        catch (IOException e) {
            this.logger.warning(e.getMessage());
            transferReport.addTransferedFile(target, e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

