/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.listeners;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import java.io.File;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.bc.filetransfer.FileTransferComponent;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.service.provide.CheckFileService;
import org.ow2.petals.bc.filetransfer.service.provide.DelFileService;
import org.ow2.petals.bc.filetransfer.service.provide.DirService;
import org.ow2.petals.bc.filetransfer.service.provide.GetFileAsAttachmentService;
import org.ow2.petals.bc.filetransfer.service.provide.GetFileService;
import org.ow2.petals.bc.filetransfer.service.provide.MGetFileService;
import org.ow2.petals.bc.filetransfer.service.provide.MPutFileService;
import org.ow2.petals.bc.filetransfer.service.provide.PutFileService;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.LoggingUtil;
import org.w3c.dom.Document;

public class FileTransferJBIListener
extends AbstractJBIListener {
    public boolean onJBIMessage(Exchange exchange) {
        block25: {
            File transferedfile;
            if (exchange.isProviderRole()) {
                AbstractFileService service = null;
                if (exchange.isActiveStatus()) {
                    try {
                        FileTransferJBIListener.validateExchange(exchange);
                        if (exchange.getFault() == null) {
                            QName operation = exchange.getOperation();
                            Document inMessageDoc = exchange.getInMessageContentAsDocument();
                            if ("get".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new GetFileService(this.getExtensions(), this.getLogger());
                            } else if ("getAsAttachment".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new GetFileAsAttachmentService(this.getExtensions(), this.getLogger());
                            } else if ("mget".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new MGetFileService(this.getExtensions(), this.getLogger());
                            } else if ("checkFile".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new CheckFileService(this.getExtensions(), this.getLogger());
                            } else if ("put".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new PutFileService(this.getExtensions(), this.getLogger());
                            } else if ("mput".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new MPutFileService(this.getExtensions(), this.getLogger());
                            } else if ("del".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new DelFileService(this.getExtensions(), this.getLogger());
                            } else if ("dir".equalsIgnoreCase(operation.getLocalPart())) {
                                service = new DirService(this.getExtensions(), this.getLogger());
                            } else {
                                String message = "The operation '" + operation + "' is not recognized";
                                throw new MessagingException(message);
                            }
                            ((AbstractFileService)service).process(exchange, inMessageDoc);
                            break block25;
                        }
                        exchange.setDoneStatus();
                    }
                    catch (MessagingException e) {
                        String correlationID = (String)exchange.getProperty("org.ow2.petals.propagate.correlation");
                        StringBuilder builder = new StringBuilder();
                        builder.append("[Exchange Id:" + exchange.getExchangeId());
                        if (!StringHelper.isNullOrEmpty((String)correlationID)) {
                            builder.append(";Correlation Id:" + correlationID);
                        }
                        builder.append("] - ");
                        builder.append(((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage());
                        this.getLogger().log(Level.WARNING, builder.toString());
                        exchange.setError((Exception)((Object)e));
                    }
                }
            } else if (!ExchangeStatus.ACTIVE.equals(exchange.getStatus()) && (transferedfile = ((FileTransferComponent)this.component).getTransferedFile(exchange)) != null) {
                this.getLogger().info("Received acknowledgment '" + exchange.getStatus().toString() + "' for transfered file '" + transferedfile.getAbsolutePath() + "'. Delete it");
                LoggingUtil.addMonitEndOrFailureTrace((Logger)this.getLogger(), (Exchange)exchange, (FlowAttributes)exchange.getFlowAttributes());
                if (!transferedfile.delete()) {
                    this.getLogger().log(Level.WARNING, "Failed to delete file '" + transferedfile.getAbsolutePath() + "'");
                }
            }
        }
        return true;
    }

    private static final void validateExchange(Exchange exchange) throws MessagingException {
        QName operation = exchange.getOperation();
        if (operation == null) {
            throw new MessagingException("The JBI operation must be set by the consumer of the service.");
        }
        if (StringHelper.isNullOrEmpty((String)operation.getNamespaceURI())) {
            exchange.setOperation(new QName("http://petals.ow2.org/components/filetransfer/version-3", operation.getLocalPart()));
        }
    }
}

