/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MGetFileService
extends AbstractFileService {
    public MGetFileService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MGET operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("mget", Message.MEPConstants.IN_OUT_PATTERN));
        }
        NodeList list = inMessageDoc.getFirstChild().getChildNodes();
        LinkedList<String> filePattern = new LinkedList<String>();
        for (int index = 0; index < list.getLength(); ++index) {
            if (!"filename".equalsIgnoreCase(list.item(index).getLocalName())) continue;
            filePattern.add(list.item(index).getTextContent());
        }
        if (filePattern.size() == 0) {
            FileTransferUtils.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            File readDirectory = null;
            try {
                readDirectory = FileTransferUtils.getFolderPath(this.extensions);
                this.logger.log(Level.INFO, "read files from : " + readDirectory.getAbsolutePath());
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < filePattern.size(); ++i) {
                    builder.append("(" + (String)filePattern.get(i) + ")");
                    if (i + 1 >= filePattern.size()) continue;
                    builder.append("|");
                }
                this.addMonitBeginStepExtTrace(builder.toString(), readDirectory.getName());
                NormalizedMessage outMessage = exchange.getOutMessage();
                List<String> fileName = this.mGet(filePattern, readDirectory, outMessage);
                Document outDoc = FileTransferUtils.generateMTOMListResponse(fileName, exchange.getOperation());
                outMessage.setContent((Source)new DOMSource(outDoc.getDocumentElement()));
                this.addMonitEndStepExtTrace();
            }
            catch (IOException e) {
                FileTransferUtils.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "] Cause : " + e.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MGET operation ended");
        }
    }

    private List<String> mGet(List<String> fileWildCardPatterns, File readDirectory, NormalizedMessage outMessage) throws MessagingException, IOException {
        File[] ls;
        LinkedList<String> retrievedFileName = new LinkedList<String>();
        LinkedList<FileNamePatternUtil.RegexFileNameFilter> fileFilters = new LinkedList<FileNamePatternUtil.RegexFileNameFilter>();
        for (String pattern : fileWildCardPatterns) {
            fileFilters.add(FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(pattern));
        }
        FileNamePatternUtil.RegexFileNameFilter filter = FileNamePatternUtil.getInstance().buildFileNameFilterFromFilters(fileFilters);
        for (File file : ls = readDirectory.listFiles()) {
            if (!file.isFile() || !filter.accept(null, file.getName())) continue;
            if (FileTransferUtils.checkAccess(file)) {
                String filename = file.getName();
                File processedFile = FileTransferUtils.moveFile(file, this.extensions);
                DataHandler attachment = new DataHandler(processedFile.toURI().toURL());
                outMessage.addAttachment(filename, attachment);
                retrievedFileName.add(filename);
                continue;
            }
            this.logger.warning("File " + file.getName() + " is locked.Permission denied");
        }
        return retrievedFileName;
    }
}

