/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.stream;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;

public class StreamHelper {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void copy(InputStream fromStream, OutputStream toStream) {
        StreamHelper.copy(fromStream, toStream, 2048);
    }

    public static void copy(InputStream fromStream, OutputStream toStream, int bufferSize) {
        assert (fromStream != null);
        assert (toStream != null);
        assert (bufferSize > 0);
        try {
            byte[] buf = new byte[bufferSize];
            int bytesRead = fromStream.read(buf);
            while (bytesRead != -1) {
                toStream.write(buf, 0, bytesRead);
                bytesRead = fromStream.read(buf);
            }
            toStream.flush();
        }
        catch (IOException e) {
            throw new UncheckedException("Cannot read or write bytes on given streams", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream input) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            StreamHelper.copy(input, result);
        }
        finally {
            IOHelper.close((Closeable)result);
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(InputStream is) throws IOException {
        StringWriter w = null;
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            w = new StringWriter();
            char[] buffer = new char[1024];
            while ((n = reader.read(buffer)) != -1) {
                w.write(buffer, 0, n);
            }
        }
        finally {
            is.close();
        }
        return w.toString();
    }
}

