/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.jbi.adaptor.impl.AbstractJBIComponentTest;
import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedComponent;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestToProviderMessage;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedStatusFromConsumerMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;
import org.junit.BeforeClass;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.component.api.Component;
import org.ow2.petals.component.api.ComponentConfiguration;
import org.ow2.petals.component.api.Message;
import org.ow2.petals.component.api.ServiceConfiguration;

public class FileTransferComponentTest
extends AbstractJBIComponentTest {
    private static final QName TEST_OPERATION = new QName("http://testProvideService", "get");
    private static File folder;

    @BeforeClass
    public static void beforeClass() throws IOException {
        folder = FileSystemHelper.createTempDir();
    }

    protected Component createComponentUnderTest(ComponentConfiguration componentConfiguration) {
        return new WrappedComponent(ComponentType.BC_FILETRANSFER, componentConfiguration);
    }

    protected Message createMessageToProcessAsProvider(ServiceConfiguration testProvideServiceConfiguration) throws Exception {
        String payload = "<?xml version='1.0' encoding='UTF-8'?>\n<tns:get xmlns:tns='http://testProvideService'>\n  <tns:filename>testFilename.txt</tns:filename>\n</tns:get>";
        return new WrappedRequestToProviderMessage(testProvideServiceConfiguration, TEST_OPERATION, AbsItfOperation.MEPPatternConstants.IN_OUT.value(), this.createPayloadInputStream(payload), new FlowAttributes("testFlowInstanceId", "testFlowStepId"));
    }

    protected Message createTestStatusMessage(ServiceConfiguration testServiceConfiguration, ExchangeStatus status) throws Exception {
        String payload = "<?xml version='1.0' encoding='UTF-8'?>\n<tns:get xmlns:tns='http://testProvideService'>\n  <tns:filename>testFilename.txt</tns:filename>\n</tns:get>";
        return new WrappedStatusFromConsumerMessage(testServiceConfiguration, TEST_OPERATION, AbsItfOperation.MEPPatternConstants.IN_OUT.value(), this.createPayloadInputStream(payload), new FlowAttributes("testFlowInstanceId", "testFlowStepId"), status);
    }

    protected ServiceConfiguration createTestProvideServiceConfiguration() throws Exception {
        ServiceConfiguration testProvideServiceConguration = this.createTestProvideServiceBaseConfiguration();
        testProvideServiceConguration.setParameter("{http://petals.ow2.org/components/filetransfer/version-3}folder", FileSystemHelper.createTempDir().getAbsolutePath());
        return testProvideServiceConguration;
    }

    protected ServiceConfiguration createTestConsumeServiceConfiguration() throws Exception {
        ServiceConfiguration testProvideServiceConguration = new ServiceConfiguration("testServiceConsume", new QName("http://testProvideService", "testProvideInterfaceName"), new QName("http://testProvideService", "testServiceName"), "testEndpointName", ServiceConfiguration.ServiceType.CONSUME);
        testProvideServiceConguration.setParameter("{http://petals.ow2.org/components/filetransfer/version-3}folder", folder.getAbsolutePath());
        return testProvideServiceConguration;
    }

    protected Map<String, String> generateExternalEvent() throws Exception {
        File tempFile = this.createXmlFile();
        File filePathToPoll = new File(folder, tempFile.getName());
        tempFile.renameTo(filePathToPoll);
        HashMap<String, String> expectedParams = new HashMap<String, String>();
        expectedParams.put("filePath", filePathToPoll.getAbsolutePath());
        return expectedParams;
    }

    private File createXmlFile() throws Exception {
        File tempFile = File.createTempFile("filetransferTest", ".xml");
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        String xmlText = "<text>vive le foot</text>";
        outputStream.write(xmlText.getBytes());
        return tempFile;
    }
}

